/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2015-2017 Christian Schudt
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/**
 * Provides classes for the <a href="https://tools.ietf.org/html/rfc8264">PRECIS framework</a> as well as related profiles.
 * <ul>
 * <li><a href="https://tools.ietf.org/html/rfc8265">Preparation, Enforcement, and Comparison of Internationalized Strings
 * Representing Usernames and Passwords
 * </a>
 * <ul>
 * <li><a href="https://tools.ietf.org/html/rfc8265#section-3.3">UsernameCaseMapped Profile</a></li>
 * <li><a href="https://tools.ietf.org/html/rfc8265#section-3.4">UsernameCasePreserved Profile</a></li>
 * <li><a href="https://tools.ietf.org/html/rfc8265#section-4.2">OpaqueString Profile</a></li>
 * </ul>
 * </li>
 * <li><a href="https://tools.ietf.org/html/rfc8266">Preparation, Enforcement, and Comparison of Internationalized Strings
 * Representing Nicknames</a></li>
 * </ul>
 *
 * @see rocks.xmpp.precis.PrecisProfiles
 */
package rocks.xmpp.precis;