#ifndef _SRT_METRICS_H
#define _SRT_METRICS_H 1

#include <atomic>
#include <vector>
#include <string>
#include <utility>

// Metrics related to an SRT stream (input or output).

struct SRTMetrics {
	std::atomic<double> metric_srt_uptime_seconds{0.0 / 0.0};
	std::atomic<double> metric_srt_send_duration_seconds{0.0 / 0.0};
	std::atomic<int64_t> metric_srt_sent_bytes{-1};
	std::atomic<int64_t> metric_srt_received_bytes{-1};
	std::atomic<int64_t> metric_srt_sent_packets_normal{-1};
	std::atomic<int64_t> metric_srt_received_packets_normal{-1};
	std::atomic<int64_t> metric_srt_sent_packets_lost{-1};
	std::atomic<int64_t> metric_srt_received_packets_lost{-1};
	std::atomic<int64_t> metric_srt_sent_packets_retransmitted{-1};
	std::atomic<int64_t> metric_srt_sent_bytes_retransmitted{-1};
	std::atomic<int64_t> metric_srt_sent_packets_ack{-1};
	std::atomic<int64_t> metric_srt_received_packets_ack{-1};
	std::atomic<int64_t> metric_srt_sent_packets_nak{-1};
	std::atomic<int64_t> metric_srt_received_packets_nak{-1};
	std::atomic<int64_t> metric_srt_sent_packets_dropped{-1};
	std::atomic<int64_t> metric_srt_received_packets_dropped{-1};
	std::atomic<int64_t> metric_srt_sent_bytes_dropped{-1};
	std::atomic<int64_t> metric_srt_received_bytes_dropped{-1};
	std::atomic<int64_t> metric_srt_received_packets_undecryptable{-1};
	std::atomic<int64_t> metric_srt_received_bytes_undecryptable{-1};

	std::atomic<int64_t> metric_srt_filter_received_extra_packets{-1};
	std::atomic<int64_t> metric_srt_filter_received_rebuilt_packets{-1};
	std::atomic<int64_t> metric_srt_filter_received_lost_packets{-1};

	std::atomic<double> metric_srt_packet_sending_period_seconds{0.0 / 0.0};
	std::atomic<int64_t> metric_srt_flow_window_packets{-1};
	std::atomic<int64_t> metric_srt_congestion_window_packets{-1};
	std::atomic<int64_t> metric_srt_flight_size_packets{-1};
	std::atomic<double> metric_srt_rtt_seconds{0.0 / 0.0};
	std::atomic<double> metric_srt_estimated_bandwidth_bits_per_second{0.0 / 0.0};
	std::atomic<double> metric_srt_bandwidth_ceiling_bits_per_second{0.0 / 0.0};
	std::atomic<int64_t> metric_srt_send_buffer_available_bytes{-1};
	std::atomic<int64_t> metric_srt_receive_buffer_available_bytes{-1};
	std::atomic<int64_t> metric_srt_mss_bytes{-1};
	std::atomic<int64_t> metric_srt_sender_unacked_packets{-1};
	std::atomic<int64_t> metric_srt_sender_unacked_bytes{-1};
	std::atomic<double> metric_srt_sender_unacked_timespan_seconds{0.0 / 0.0};
	std::atomic<double> metric_srt_sender_delivery_delay_seconds{0.0 / 0.0};
	std::atomic<int64_t> metric_srt_receiver_unacked_packets{-1};
	std::atomic<int64_t> metric_srt_receiver_unacked_bytes{-1};
	std::atomic<double> metric_srt_receiver_unacked_timespan_seconds{0.0 / 0.0};
	std::atomic<double> metric_srt_receiver_delivery_delay_seconds{0.0 / 0.0};
	std::atomic<int64_t> metric_srt_filter_sent_packets{-1};

	// Registers in global_metrics.
	void init(const std::vector<std::pair<std::string, std::string>> &labels);

	// Unregisters similarly.
	void deinit(const std::vector<std::pair<std::string, std::string>> &labels);

	void update_srt_stats(int srt_sock);
};

#endif

