// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file primitives_struct.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__PRIMITIVES_STRUCT_HPP
#define FAST_DDS_GENERATED__PRIMITIVES_STRUCT_HPP

#include <cstdint>
#include <utility>

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(PRIMITIVES_STRUCT_SOURCE)
#define PRIMITIVES_STRUCT_DllAPI __declspec( dllexport )
#else
#define PRIMITIVES_STRUCT_DllAPI __declspec( dllimport )
#endif // PRIMITIVES_STRUCT_SOURCE
#else
#define PRIMITIVES_STRUCT_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define PRIMITIVES_STRUCT_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the structure PrimitivesStruct defined by the user in the IDL file.
 * @ingroup primitives_struct
 */
class PrimitivesStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport PrimitivesStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~PrimitivesStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object PrimitivesStruct that will be copied.
     */
    eProsima_user_DllExport PrimitivesStruct(
            const PrimitivesStruct& x)
    {
                    m_my_bool = x.m_my_bool;

                    m_my_octet = x.m_my_octet;

                    m_my_char = x.m_my_char;

                    m_my_wchar = x.m_my_wchar;

                    m_my_long = x.m_my_long;

                    m_my_ulong = x.m_my_ulong;

                    m_my_int8 = x.m_my_int8;

                    m_my_uint8 = x.m_my_uint8;

                    m_my_short = x.m_my_short;

                    m_my_ushort = x.m_my_ushort;

                    m_my_longlong = x.m_my_longlong;

                    m_my_ulonglong = x.m_my_ulonglong;

                    m_my_float = x.m_my_float;

                    m_my_double = x.m_my_double;

                    m_my_longdouble = x.m_my_longdouble;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object PrimitivesStruct that will be copied.
     */
    eProsima_user_DllExport PrimitivesStruct(
            PrimitivesStruct&& x) noexcept
    {
        m_my_bool = x.m_my_bool;
        m_my_octet = x.m_my_octet;
        m_my_char = x.m_my_char;
        m_my_wchar = x.m_my_wchar;
        m_my_long = x.m_my_long;
        m_my_ulong = x.m_my_ulong;
        m_my_int8 = x.m_my_int8;
        m_my_uint8 = x.m_my_uint8;
        m_my_short = x.m_my_short;
        m_my_ushort = x.m_my_ushort;
        m_my_longlong = x.m_my_longlong;
        m_my_ulonglong = x.m_my_ulonglong;
        m_my_float = x.m_my_float;
        m_my_double = x.m_my_double;
        m_my_longdouble = x.m_my_longdouble;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object PrimitivesStruct that will be copied.
     */
    eProsima_user_DllExport PrimitivesStruct& operator =(
            const PrimitivesStruct& x)
    {

                    m_my_bool = x.m_my_bool;

                    m_my_octet = x.m_my_octet;

                    m_my_char = x.m_my_char;

                    m_my_wchar = x.m_my_wchar;

                    m_my_long = x.m_my_long;

                    m_my_ulong = x.m_my_ulong;

                    m_my_int8 = x.m_my_int8;

                    m_my_uint8 = x.m_my_uint8;

                    m_my_short = x.m_my_short;

                    m_my_ushort = x.m_my_ushort;

                    m_my_longlong = x.m_my_longlong;

                    m_my_ulonglong = x.m_my_ulonglong;

                    m_my_float = x.m_my_float;

                    m_my_double = x.m_my_double;

                    m_my_longdouble = x.m_my_longdouble;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object PrimitivesStruct that will be copied.
     */
    eProsima_user_DllExport PrimitivesStruct& operator =(
            PrimitivesStruct&& x) noexcept
    {

        m_my_bool = x.m_my_bool;
        m_my_octet = x.m_my_octet;
        m_my_char = x.m_my_char;
        m_my_wchar = x.m_my_wchar;
        m_my_long = x.m_my_long;
        m_my_ulong = x.m_my_ulong;
        m_my_int8 = x.m_my_int8;
        m_my_uint8 = x.m_my_uint8;
        m_my_short = x.m_my_short;
        m_my_ushort = x.m_my_ushort;
        m_my_longlong = x.m_my_longlong;
        m_my_ulonglong = x.m_my_ulonglong;
        m_my_float = x.m_my_float;
        m_my_double = x.m_my_double;
        m_my_longdouble = x.m_my_longdouble;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x PrimitivesStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const PrimitivesStruct& x) const
    {
        return (m_my_bool == x.m_my_bool &&
           m_my_octet == x.m_my_octet &&
           m_my_char == x.m_my_char &&
           m_my_wchar == x.m_my_wchar &&
           m_my_long == x.m_my_long &&
           m_my_ulong == x.m_my_ulong &&
           m_my_int8 == x.m_my_int8 &&
           m_my_uint8 == x.m_my_uint8 &&
           m_my_short == x.m_my_short &&
           m_my_ushort == x.m_my_ushort &&
           m_my_longlong == x.m_my_longlong &&
           m_my_ulonglong == x.m_my_ulonglong &&
           m_my_float == x.m_my_float &&
           m_my_double == x.m_my_double &&
           m_my_longdouble == x.m_my_longdouble);
    }

    /*!
     * @brief Comparison operator.
     * @param x PrimitivesStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const PrimitivesStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member my_bool
     * @param _my_bool New value for member my_bool
     */
    eProsima_user_DllExport void my_bool(
            bool _my_bool)
    {
        m_my_bool = _my_bool;
    }

    /*!
     * @brief This function returns the value of member my_bool
     * @return Value of member my_bool
     */
    eProsima_user_DllExport bool my_bool() const
    {
        return m_my_bool;
    }

    /*!
     * @brief This function returns a reference to member my_bool
     * @return Reference to member my_bool
     */
    eProsima_user_DllExport bool& my_bool()
    {
        return m_my_bool;
    }


    /*!
     * @brief This function sets a value in member my_octet
     * @param _my_octet New value for member my_octet
     */
    eProsima_user_DllExport void my_octet(
            uint8_t _my_octet)
    {
        m_my_octet = _my_octet;
    }

    /*!
     * @brief This function returns the value of member my_octet
     * @return Value of member my_octet
     */
    eProsima_user_DllExport uint8_t my_octet() const
    {
        return m_my_octet;
    }

    /*!
     * @brief This function returns a reference to member my_octet
     * @return Reference to member my_octet
     */
    eProsima_user_DllExport uint8_t& my_octet()
    {
        return m_my_octet;
    }


    /*!
     * @brief This function sets a value in member my_char
     * @param _my_char New value for member my_char
     */
    eProsima_user_DllExport void my_char(
            char _my_char)
    {
        m_my_char = _my_char;
    }

    /*!
     * @brief This function returns the value of member my_char
     * @return Value of member my_char
     */
    eProsima_user_DllExport char my_char() const
    {
        return m_my_char;
    }

    /*!
     * @brief This function returns a reference to member my_char
     * @return Reference to member my_char
     */
    eProsima_user_DllExport char& my_char()
    {
        return m_my_char;
    }


    /*!
     * @brief This function sets a value in member my_wchar
     * @param _my_wchar New value for member my_wchar
     */
    eProsima_user_DllExport void my_wchar(
            wchar_t _my_wchar)
    {
        m_my_wchar = _my_wchar;
    }

    /*!
     * @brief This function returns the value of member my_wchar
     * @return Value of member my_wchar
     */
    eProsima_user_DllExport wchar_t my_wchar() const
    {
        return m_my_wchar;
    }

    /*!
     * @brief This function returns a reference to member my_wchar
     * @return Reference to member my_wchar
     */
    eProsima_user_DllExport wchar_t& my_wchar()
    {
        return m_my_wchar;
    }


    /*!
     * @brief This function sets a value in member my_long
     * @param _my_long New value for member my_long
     */
    eProsima_user_DllExport void my_long(
            int32_t _my_long)
    {
        m_my_long = _my_long;
    }

    /*!
     * @brief This function returns the value of member my_long
     * @return Value of member my_long
     */
    eProsima_user_DllExport int32_t my_long() const
    {
        return m_my_long;
    }

    /*!
     * @brief This function returns a reference to member my_long
     * @return Reference to member my_long
     */
    eProsima_user_DllExport int32_t& my_long()
    {
        return m_my_long;
    }


    /*!
     * @brief This function sets a value in member my_ulong
     * @param _my_ulong New value for member my_ulong
     */
    eProsima_user_DllExport void my_ulong(
            uint32_t _my_ulong)
    {
        m_my_ulong = _my_ulong;
    }

    /*!
     * @brief This function returns the value of member my_ulong
     * @return Value of member my_ulong
     */
    eProsima_user_DllExport uint32_t my_ulong() const
    {
        return m_my_ulong;
    }

    /*!
     * @brief This function returns a reference to member my_ulong
     * @return Reference to member my_ulong
     */
    eProsima_user_DllExport uint32_t& my_ulong()
    {
        return m_my_ulong;
    }


    /*!
     * @brief This function sets a value in member my_int8
     * @param _my_int8 New value for member my_int8
     */
    eProsima_user_DllExport void my_int8(
            int8_t _my_int8)
    {
        m_my_int8 = _my_int8;
    }

    /*!
     * @brief This function returns the value of member my_int8
     * @return Value of member my_int8
     */
    eProsima_user_DllExport int8_t my_int8() const
    {
        return m_my_int8;
    }

    /*!
     * @brief This function returns a reference to member my_int8
     * @return Reference to member my_int8
     */
    eProsima_user_DllExport int8_t& my_int8()
    {
        return m_my_int8;
    }


    /*!
     * @brief This function sets a value in member my_uint8
     * @param _my_uint8 New value for member my_uint8
     */
    eProsima_user_DllExport void my_uint8(
            uint8_t _my_uint8)
    {
        m_my_uint8 = _my_uint8;
    }

    /*!
     * @brief This function returns the value of member my_uint8
     * @return Value of member my_uint8
     */
    eProsima_user_DllExport uint8_t my_uint8() const
    {
        return m_my_uint8;
    }

    /*!
     * @brief This function returns a reference to member my_uint8
     * @return Reference to member my_uint8
     */
    eProsima_user_DllExport uint8_t& my_uint8()
    {
        return m_my_uint8;
    }


    /*!
     * @brief This function sets a value in member my_short
     * @param _my_short New value for member my_short
     */
    eProsima_user_DllExport void my_short(
            int16_t _my_short)
    {
        m_my_short = _my_short;
    }

    /*!
     * @brief This function returns the value of member my_short
     * @return Value of member my_short
     */
    eProsima_user_DllExport int16_t my_short() const
    {
        return m_my_short;
    }

    /*!
     * @brief This function returns a reference to member my_short
     * @return Reference to member my_short
     */
    eProsima_user_DllExport int16_t& my_short()
    {
        return m_my_short;
    }


    /*!
     * @brief This function sets a value in member my_ushort
     * @param _my_ushort New value for member my_ushort
     */
    eProsima_user_DllExport void my_ushort(
            uint16_t _my_ushort)
    {
        m_my_ushort = _my_ushort;
    }

    /*!
     * @brief This function returns the value of member my_ushort
     * @return Value of member my_ushort
     */
    eProsima_user_DllExport uint16_t my_ushort() const
    {
        return m_my_ushort;
    }

    /*!
     * @brief This function returns a reference to member my_ushort
     * @return Reference to member my_ushort
     */
    eProsima_user_DllExport uint16_t& my_ushort()
    {
        return m_my_ushort;
    }


    /*!
     * @brief This function sets a value in member my_longlong
     * @param _my_longlong New value for member my_longlong
     */
    eProsima_user_DllExport void my_longlong(
            int64_t _my_longlong)
    {
        m_my_longlong = _my_longlong;
    }

    /*!
     * @brief This function returns the value of member my_longlong
     * @return Value of member my_longlong
     */
    eProsima_user_DllExport int64_t my_longlong() const
    {
        return m_my_longlong;
    }

    /*!
     * @brief This function returns a reference to member my_longlong
     * @return Reference to member my_longlong
     */
    eProsima_user_DllExport int64_t& my_longlong()
    {
        return m_my_longlong;
    }


    /*!
     * @brief This function sets a value in member my_ulonglong
     * @param _my_ulonglong New value for member my_ulonglong
     */
    eProsima_user_DllExport void my_ulonglong(
            uint64_t _my_ulonglong)
    {
        m_my_ulonglong = _my_ulonglong;
    }

    /*!
     * @brief This function returns the value of member my_ulonglong
     * @return Value of member my_ulonglong
     */
    eProsima_user_DllExport uint64_t my_ulonglong() const
    {
        return m_my_ulonglong;
    }

    /*!
     * @brief This function returns a reference to member my_ulonglong
     * @return Reference to member my_ulonglong
     */
    eProsima_user_DllExport uint64_t& my_ulonglong()
    {
        return m_my_ulonglong;
    }


    /*!
     * @brief This function sets a value in member my_float
     * @param _my_float New value for member my_float
     */
    eProsima_user_DllExport void my_float(
            float _my_float)
    {
        m_my_float = _my_float;
    }

    /*!
     * @brief This function returns the value of member my_float
     * @return Value of member my_float
     */
    eProsima_user_DllExport float my_float() const
    {
        return m_my_float;
    }

    /*!
     * @brief This function returns a reference to member my_float
     * @return Reference to member my_float
     */
    eProsima_user_DllExport float& my_float()
    {
        return m_my_float;
    }


    /*!
     * @brief This function sets a value in member my_double
     * @param _my_double New value for member my_double
     */
    eProsima_user_DllExport void my_double(
            double _my_double)
    {
        m_my_double = _my_double;
    }

    /*!
     * @brief This function returns the value of member my_double
     * @return Value of member my_double
     */
    eProsima_user_DllExport double my_double() const
    {
        return m_my_double;
    }

    /*!
     * @brief This function returns a reference to member my_double
     * @return Reference to member my_double
     */
    eProsima_user_DllExport double& my_double()
    {
        return m_my_double;
    }


    /*!
     * @brief This function sets a value in member my_longdouble
     * @param _my_longdouble New value for member my_longdouble
     */
    eProsima_user_DllExport void my_longdouble(
            long double _my_longdouble)
    {
        m_my_longdouble = _my_longdouble;
    }

    /*!
     * @brief This function returns the value of member my_longdouble
     * @return Value of member my_longdouble
     */
    eProsima_user_DllExport long double my_longdouble() const
    {
        return m_my_longdouble;
    }

    /*!
     * @brief This function returns a reference to member my_longdouble
     * @return Reference to member my_longdouble
     */
    eProsima_user_DllExport long double& my_longdouble()
    {
        return m_my_longdouble;
    }



private:

    bool m_my_bool{false};
    uint8_t m_my_octet{0};
    char m_my_char{0};
    wchar_t m_my_wchar{0};
    int32_t m_my_long{0};
    uint32_t m_my_ulong{0};
    int8_t m_my_int8{0};
    uint8_t m_my_uint8{0};
    int16_t m_my_short{0};
    uint16_t m_my_ushort{0};
    int64_t m_my_longlong{0};
    uint64_t m_my_ulonglong{0};
    float m_my_float{0.0};
    double m_my_double{0.0};
    long double m_my_longdouble{0.0};

};

#endif // _FAST_DDS_GENERATED_PRIMITIVES_STRUCT_HPP_


