AWS Security Hub consolidates findings from a multitude of sources. For a detailed list of integrations with AWS Services and third-party products, please refer to its [official documentation](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-providers.html).

Given the variety of finding contents, DefectDojo offers varying degrees of support for each provider. However, it should at least import basic information without errors.

This directory contains sample reports from Security Hub. They are meant as test cases.

To keep some order, let's keep them prefixed with the names of the services that generated them:

* `config_`: findings generated by AWS Config rules, for example by benchmarking against "AWS Foundational Security Best Practices"

* `inspector_ec2_`: findings from AWS Inspector with results of scanning EC2 instances

* `inspector_ecr_`: findings from AWS Inspector with results of Enhanced ECR Scanning, currently contains 7 findings with vulnerabilities associated with 8 different values of `PackageManager`

* `inspector_lambda_`: findings from AWS Inspector with results of scanning Lambdas

* `guardduty_`: findings from AWS Guard Duty
