# Debmake documentation

This is the source file for debmake-doc package.
## Table of Contents
1. [Introduction](#introduction)
2. [Git Repository](#git-repository)
3. [Build System](#build-system)
4. [Pre-build](#pre-build)
5. [Debug Builds](#debug-builds)
6. [Translation](#translation)
7. [Source Upload](#source-upload)

## Introduction

 * https://salsa.debian.org/debian/debmake-doc (upstream site)
 * https://www.debian.org/doc/devel-manuals#debmake-doc (build pages)
 * https://www.debian.org/doc/manuals/debmake-doc/index.en.html (English content)

All files included in this source tree are under the MIT license with its text
in the LICENSE file except for the files which explicitly claim differently in
them.

The English ASCIIDOC source is converted to use the well-maintained
[Asciidoctor 2](https://asciidoctor.org) platform. It is used to generate XML
intermediate files. HTML files are generated using XML processing tools
(xslt). PDF files are generated by dblatex with XeLaTeX backend.

## Git repository

NOTE: The use of the "devel" branch is deprecated.

All updates should be committed to the "main" branch of the git repository at:

  https://salsa.debian.org/debian/debmake-doc

The "main" branch is meant to build the non-native Debian binary package. The
version number in debian/changelog is a non-native version number. This works
since this is also the upstream repo. For minor updates, we can use -2 revision,
too. See `man dgit-maint-merge` for more information.

Test build:

```shell
git deborig -f HEAD
sbuild
```

Keeping track of changes in git on the command-line is challenging. Please use
[gitk](https://manpages.debian.org/unstable/gitk/gitk.1.en.html) as a visual aid
and refresh the view with `F5` after every git operation.

When building revision packages such as -2, -3, ..., obtain and use the
original tar file used for -1 revision instead of using `git deborig -f HEAD`.

## Build system

The build system involves several `Makefile`s for make:

* Makefile -- "package" target does "git deborig -f HEAD; sbuild"
* examples/Makefile -- "all" target to generate the packaging example logs

For `sbuild` configuration, see https://wiki.debian.org/sbuild.

### Normal build

The packaging of debmake-doc is:

* Package build by "make package" from the git "main" branch.
* Upload package with "dput" or "dgit push-source" (source only for Debian)

### Pre-build

Prior to the execution of "make package", the up-to-date packaging example
logs need to be created as pre-build contents under the latest `unstable`
chroot environment and committed to the source tree (See details in
[examples/README.md](examples/README.md)).

```shell
make clean
cd examples
make
make clean
git add -A .
git commit -m "Update example logs"
```

### Preliminary debug build of single-page English html

If you are debugging ASCIIDOC markup issues with newly updated build log
examples and wish to test the ASCIIDOC source quickly without going through
XML, here is an alternative HTML build method:

```shell
cd asciidoc
make
```

The result is `asciidoc/debmake-doc.html`

Please commit English ASCIIDOC source text contents to the git repository after
making sure all the above are bug-free.

This also builds an updated manpage which can be copied to the debmake package.

### Debug build (English updates)

Update English original content by editing ASCIIDOC text files under the
`asciidoc/` directory. The result of the debug build can be previewed with a
browser by generating HTML files.

```shell
make LANGPO= doc-test
```

Please note that `LANGPO` is set to an empty string in the above command to skip
translation.

If you get an error-free HTML file, you may wish to check the PDF file:

```shell
make LANGPO= pdf  # preview PDF
```

Results are found under `basedir/`.

### Debug build (non-English updates)

Before working on updating translations, please make sure to refresh files under
the `po4a/po/` directory (a.k.a. PO files) for your language `<lang>` from the
latest ASCIIDOC text contents.

```shell
$ git pull
$ make LANGPO=<lang> po
... update po4a/po/<lang>.po
```

You can translate this source by editing PO files for `LANGPO=<lang>` under the
`po4a/po/` directory using tools such as
[poedit](https://manpages.debian.org/unstable/poedit/poedit.1.en.html).

The result of the debug build can be previewed with a browser by generating HTML
files in a way similar to the "Debug build (English updates)" while specifying
the `<lang>`.

```shell
make LANGPO=<lang> doc-test
```

If you get an error-free HTML file, you may wish to check the PDF file too:

```shell
make LANGPO=<lang> pdf  # preview PDF
```

Results are found under `basedir/`.

If the result of your translation previewed with the browser and PDF viewer
is good, please commit `po4a/po/<lang>.po` only as follows:

```shell
git add po4a/po/<lang>.po
git commit -m "Updated <lang>.po"
git reset --hard HEAD
git clean -d -f -x
```

### Translation in po4a/po directory

This directory contain po files for translators.  This is done using
[po4a](https://manpages.debian.org/unstable/po4a/po4a.7.en.html).

If two people happen to modify the same PO file at the same time, do not use git
to solve the merge conflict as it is too complex. Instead use the
`bin/msgmsguniq` script to help merging po files. For example, to merge
`<lang>.po.my` and `<lang>.po.their` run:

```shell
bin/msgmsguniq <lang>.po.my <lang>.po.their > <lang>.po
```

Then move this generated `<lang>.po` to `po4a/po/<lang>.po` and normalize it
with:

```shell
make LANGPO=<lang> po
```

Now you have merged PO to `po4a/po/<lang>.po`.

You may un-fuzzy manually and commit the clean tested `po4a/po/<lang>.po` to
the git repository.

### Files in `asciidoc/`

This directory contains the source text files written in the ASCIIDOC markup.
Their extension is usually `.txt`.

### Source upload

Make source package and record it to git:

```shell
git reset --hard HEAD # clean source tree
git clean -d -f -x
git rm -rf debian
git commit -m "upstream/1.21"
git tag "upstream/1.21"
git reset --hard HEAD^
git deborig
sbuild # test build
...
dgit push-source
```
<!-- vim:se tw=78 sts=4 ts=4 et ai: -->
