/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.task;

import java.util.StringJoiner;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.messages.ModelMessages;

public class DBTTaskRunStatus {
    private String resultMessage;

    @Nullable
    public String getResultMessage() {
        return this.resultMessage;
    }

    public void setResultMessage(String message) {
        this.resultMessage = message;
    }

    public static DBTTaskRunStatus makeStatisticsStatus(DBCStatistics statistics) {
        DBTTaskRunStatus taskResultStatus = new DBTTaskRunStatus();
        if (statistics.getRowsFetched() > 0L || statistics.getRowsUpdated() > 0L || statistics.getStatementsCount() > 0) {
            StringJoiner joiner = new StringJoiner(", ");
            if (statistics.getRowsFetched() > 0L) {
                joiner.add(NLS.bind((String)ModelMessages.task_rows_fetched_message_part, (Object)statistics.getRowsFetched()));
            }
            if (statistics.getRowsUpdated() > 0L) {
                joiner.add(NLS.bind((String)ModelMessages.task_rows_modified_message_part, (Object)statistics.getRowsUpdated()));
            }
            if (statistics.getStatementsCount() > 0) {
                joiner.add(NLS.bind((String)ModelMessages.task_statements_executed_message_part, (Object)statistics.getStatementsCount()));
            }
            taskResultStatus.setResultMessage(joiner.toString());
        }
        return taskResultStatus;
    }
}

