package MyTypes::ArrayOfPerson;
use strict;
use warnings;


our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %NewElement_of :ATTR(:get<NewElement>);

__PACKAGE__->_factory(
    [ qw(        NewElement

    ) ],
    {
        'NewElement' => \%NewElement_of,
    },
    {
        'NewElement' => 'MyTypes::Person',
    },
    {

        'NewElement' => 'NewElement',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::ArrayOfPerson

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ArrayOfPerson from the namespace http://www.example.org/benchmark/.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * NewElement




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::ArrayOfPerson
   NewElement =>  { # MyTypes::Person
     PersonID =>  { # MyTypes::PersonID
       ID =>  $some_value, # int
     },
     Salutation =>  $some_value, # string
     Name =>  $some_value, # string
     GivenName =>  $some_value, # string
     DateOfBirth =>  $some_value, # date
     HomeAddress =>  { # MyTypes::Address
       Street =>  $some_value, # string
       ZIP =>  $some_value, # string
       City =>  $some_value, # string
       Country =>  $some_value, # string
       PhoneNumber => $some_value, # PhoneNumber
       MobilePhoneNumber => $some_value, # PhoneNumber
     },
     WorkAddress =>  { # MyTypes::Address
       Street =>  $some_value, # string
       ZIP =>  $some_value, # string
       City =>  $some_value, # string
       Country =>  $some_value, # string
       PhoneNumber => $some_value, # PhoneNumber
       MobilePhoneNumber => $some_value, # PhoneNumber
     },
     Contracts =>  { # MyTypes::ArrayOfContract
       Contract =>  { # MyTypes::Contract
         ContractID =>  $some_value, # long
         ContractName =>  $some_value, # string
       },
     },
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

