
######################################################################
## $Id: SelectSaveAs.pm 3668 2006-03-11 20:51:13Z spadkins $
######################################################################

package App::Widget::SelectSaveAs;
$VERSION = (q$Revision: 3668 $ =~ /(\d[\d\.]*)/)[0];  # VERSION numbers generated by svn

use App::Widget::StylizableContainer;
@ISA = ( "App::Widget::StylizableContainer" );

use strict;

=head1 NAME

App::Widget::SelectSaveAs - Select from a list: Open Save Delete SaveAs

=head1 SYNOPSIS


=cut

######################################################################
# ATTRIBUTES
######################################################################

# INPUTS FROM THE ENVIRONMENT

=head1 DESCRIPTION

This class is a select element, followed by four buttons.

=cut

######################################################################
# CONSTRUCTOR
######################################################################

sub _init {
    my $self = shift;
    $self->SUPER::_init(@_);
    my $name = $self->{name};
    my $context = $self->{context};

    # NOTE: container is inferred by the naming convention
    #       otherwise, I should include "container => $name," line
    $context->widget("${name}-selected",  # note: container is inferred
        class => "App::Widget::Select",
        #lightweight => 1,
    );

    $context->widget("${name}-open",
        class => "App::Widget::Button",
        label => "Open",
        #lightweight => 1,
    );

    $context->widget("${name}-save",
        class => "App::Widget::Button",
        label => "Save",
        #lightweight => 1,
    );

    $context->widget("${name}-delete",
        class => "App::Widget::Button",
        label => "Delete",
        #lightweight => 1,
    );

    $context->widget("${name}-saveas",
        class => "App::Widget::Button",
        label => "Save As",
        #lightweight => 1,
    );

    $context->widget("${name}-saveas_selected",  # note: container is inferred
        class => "App::Widget::TextField",
        #lightweight => 1,
    );

    # initialize value to "default" if not already set
    $context->so_get($name, undef, "default", 1);
}

######################################################################
# EVENTS
######################################################################

# Usage: $widget->handle_event($name, $event, @args);
sub handle_event {
    my ($self, $name, $event, @args) = @_;

    if ($event eq "change") {
        $self->change();
        return 1;
    }
    else {
        return $self->SUPER::handle_event($name, $event, @args);
    }
}

sub change {
    my ($self) = @_;
    my $context = $self->{context};
    my $name = $self->{name};
    my $value = $context->so_get("${name}-selected");
    if ($value) {
        $context->so_set($name, undef, $value);
    }
}

######################################################################
# OUTPUT METHODS
######################################################################

sub html {
    my $self = shift;
    my ($context, $name);

    $context = $self->{context};
    $name = $self->{name};

    return 
        $context->widget("${name}-selected")->html() . "&nbsp;" .
        $context->widget("${name}-open")->html() . "&nbsp;" .
        $context->widget("${name}-save")->html() . "&nbsp;" .
        $context->widget("${name}-delete")->html() . "&nbsp;:&nbsp;" .
        $context->widget("${name}-saveas")->html() . "&nbsp;" .
        $context->widget("${name}-saveas_selected")->html() .
        $self->callback_event_tag("change");
}

1;

