
package Amazon::API::SQS;

# Autogenerated by Amazon/API/Botocore.pm 1.2.7 at Wed Apr 27 03:13:42 2022

use strict;
use warnings;

use parent qw{ Amazon::API };

our @API_METHODS = qw{
  AddPermission
  ChangeMessageVisibility
  ChangeMessageVisibilityBatch
  CreateQueue
  DeleteMessage
  DeleteMessageBatch
  DeleteQueue
  GetQueueAttributes
  GetQueueUrl
  ListDeadLetterSourceQueues
  ListQueueTags
  ListQueues
  PurgeQueue
  ReceiveMessage
  RemovePermission
  SendMessage
  SendMessageBatch
  SetQueueAttributes
  TagQueue
  UntagQueue
};

our $VERSION = '1.2.7';

sub new {
  my ( $class, @options ) = @_;
  $class = ref($class) || $class;

  my %options = ref $options[0] ? %{ $options[0] } : @options;

  my $self = $class->SUPER::new(
    { service           => 'sqs',
      endpoint_prefix   => 'sqs',
      version           => '2012-11-05',
      target_prefix     => '',
      api_methods       => \@API_METHODS,
      content_type      => 'application/x-www-form-urlencoded',
      botocore_metadata => {
        'protocol'            => 'query',
        'serviceFullName'     => 'Amazon Simple Queue Service',
        'uid'                 => 'sqs-2012-11-05',
        'signatureVersion'    => 'v4',
        'apiVersion'          => '2012-11-05',
        'xmlNamespace'        => 'http://queue.amazonaws.com/doc/2012-11-05/',
        'serviceId'           => 'SQS',
        'serviceAbbreviation' => 'Amazon SQS',
        'endpointPrefix'      => 'sqs'
      },
      botocore_operations => {
        'TagQueue' => {
          'input' => { 'shape' => 'TagQueueRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name' => 'TagQueue'
        },
        'SendMessage' => {
          'errors' => [
            { 'shape' => 'InvalidMessageContents' },
            { 'shape' => 'UnsupportedOperation' }
          ],
          'input' => { 'shape' => 'SendMessageRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'SendMessage',
          'output' => {
            'resultWrapper' => 'SendMessageResult',
            'shape'         => 'SendMessageResult'
          }
        },
        'RemovePermission' => {
          'input' => { 'shape' => 'RemovePermissionRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name' => 'RemovePermission'
        },
        'PurgeQueue' => {
          'errors' => [
            { 'shape' => 'QueueDoesNotExist' },
            { 'shape' => 'PurgeQueueInProgress' }
          ],
          'input' => { 'shape' => 'PurgeQueueRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name' => 'PurgeQueue'
        },
        'ListQueues' => {
          'input' => { 'shape' => 'ListQueuesRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'ListQueues',
          'output' => {
            'resultWrapper' => 'ListQueuesResult',
            'shape'         => 'ListQueuesResult'
          }
        },
        'DeleteMessageBatch' => {
          'errors' => [
            { 'shape' => 'TooManyEntriesInBatchRequest' },
            { 'shape' => 'EmptyBatchRequest' },
            { 'shape' => 'BatchEntryIdsNotDistinct' },
            { 'shape' => 'InvalidBatchEntryId' }
          ],
          'input' => { 'shape' => 'DeleteMessageBatchRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'DeleteMessageBatch',
          'output' => {
            'resultWrapper' => 'DeleteMessageBatchResult',
            'shape'         => 'DeleteMessageBatchResult'
          }
        },
        'SetQueueAttributes' => {
          'errors' => [ { 'shape' => 'InvalidAttributeName' } ],
          'input'  => { 'shape' => 'SetQueueAttributesRequest' },
          'http'   => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name' => 'SetQueueAttributes'
        },
        'ChangeMessageVisibilityBatch' => {
          'errors' => [
            { 'shape' => 'TooManyEntriesInBatchRequest' },
            { 'shape' => 'EmptyBatchRequest' },
            { 'shape' => 'BatchEntryIdsNotDistinct' },
            { 'shape' => 'InvalidBatchEntryId' }
          ],
          'input' => { 'shape' => 'ChangeMessageVisibilityBatchRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'ChangeMessageVisibilityBatch',
          'output' => {
            'resultWrapper' => 'ChangeMessageVisibilityBatchResult',
            'shape'         => 'ChangeMessageVisibilityBatchResult'
          }
        },
        'GetQueueAttributes' => {
          'errors' => [ { 'shape' => 'InvalidAttributeName' } ],
          'input'  => { 'shape' => 'GetQueueAttributesRequest' },
          'http'   => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'GetQueueAttributes',
          'output' => {
            'resultWrapper' => 'GetQueueAttributesResult',
            'shape'         => 'GetQueueAttributesResult'
          }
        },
        'DeleteMessage' => {
          'errors' => [
            { 'shape' => 'InvalidIdFormat' },
            { 'shape' => 'ReceiptHandleIsInvalid' }
          ],
          'input' => { 'shape' => 'DeleteMessageRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name' => 'DeleteMessage'
        },
        'AddPermission' => {
          'errors' => [ { 'shape' => 'OverLimit' } ],
          'input'  => { 'shape' => 'AddPermissionRequest' },
          'http'   => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name' => 'AddPermission'
        },
        'ListQueueTags' => {
          'input' => { 'shape' => 'ListQueueTagsRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'ListQueueTags',
          'output' => {
            'resultWrapper' => 'ListQueueTagsResult',
            'shape'         => 'ListQueueTagsResult'
          }
        },
        'CreateQueue' => {
          'errors' => [
            { 'shape' => 'QueueDeletedRecently' },
            { 'shape' => 'QueueNameExists' }
          ],
          'input' => { 'shape' => 'CreateQueueRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'CreateQueue',
          'output' => {
            'resultWrapper' => 'CreateQueueResult',
            'shape'         => 'CreateQueueResult'
          }
        },
        'SendMessageBatch' => {
          'errors' => [
            { 'shape' => 'TooManyEntriesInBatchRequest' },
            { 'shape' => 'EmptyBatchRequest' },
            { 'shape' => 'BatchEntryIdsNotDistinct' },
            { 'shape' => 'BatchRequestTooLong' },
            { 'shape' => 'InvalidBatchEntryId' },
            { 'shape' => 'UnsupportedOperation' }
          ],
          'input' => { 'shape' => 'SendMessageBatchRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'SendMessageBatch',
          'output' => {
            'resultWrapper' => 'SendMessageBatchResult',
            'shape'         => 'SendMessageBatchResult'
          }
        },
        'ListDeadLetterSourceQueues' => {
          'errors' => [ { 'shape' => 'QueueDoesNotExist' } ],
          'input'  => { 'shape' => 'ListDeadLetterSourceQueuesRequest' },
          'http'   => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'ListDeadLetterSourceQueues',
          'output' => {
            'resultWrapper' => 'ListDeadLetterSourceQueuesResult',
            'shape'         => 'ListDeadLetterSourceQueuesResult'
          }
        },
        'ReceiveMessage' => {
          'errors' => [ { 'shape' => 'OverLimit' } ],
          'input'  => { 'shape' => 'ReceiveMessageRequest' },
          'http'   => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'ReceiveMessage',
          'output' => {
            'resultWrapper' => 'ReceiveMessageResult',
            'shape'         => 'ReceiveMessageResult'
          }
        },
        'UntagQueue' => {
          'input' => { 'shape' => 'UntagQueueRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name' => 'UntagQueue'
        },
        'GetQueueUrl' => {
          'errors' => [ { 'shape' => 'QueueDoesNotExist' } ],
          'input'  => { 'shape' => 'GetQueueUrlRequest' },
          'http'   => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'GetQueueUrl',
          'output' => {
            'resultWrapper' => 'GetQueueUrlResult',
            'shape'         => 'GetQueueUrlResult'
          }
        },
        'DeleteQueue' => {
          'input' => { 'shape' => 'DeleteQueueRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name' => 'DeleteQueue'
        },
        'ChangeMessageVisibility' => {
          'errors' => [
            { 'shape' => 'MessageNotInflight' },
            { 'shape' => 'ReceiptHandleIsInvalid' }
          ],
          'input' => { 'shape' => 'ChangeMessageVisibilityRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name' => 'ChangeMessageVisibility'
        }
      },
      debug         => $ENV{DEBUG} // 0,
      decode_always => 1,
      %options
    }
  );

  return $self;
} ## end sub new

1;

__END__

=pod

=head1 NAME

Amazon::API::SQS

=head1 DESCRIPTION

Amazon Simple Queue Service

=head1 VERSION

Version 1.2.7

=head1 METHODS


=head2 AddPermission

=pod

Adds a permission to a queue for a specific principal
(https://docs.aws.amazon.com/general/latest/gr/glos-chap.html#P). This
allows sharing access to the queue.

When you create a queue, you have full control access rights for the
queue. Only you, the owner of the queue, can grant or deny permissions
to the queue. For more information about these permissions, see Allow
Developers to Write Messages to a Shared Queue
(https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-writing-an-sqs-policy.html#write-messages-to-shared-queue)
in the I<Amazon SQS Developer Guide>.

=over

=item *

C<AddPermission> generates a policy for you. You can use C<
SetQueueAttributes > to upload your policy. For more information, see
Using Custom Policies with the Amazon SQS Access Policy Language
(https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-creating-custom-policies.html)
in the I<Amazon SQS Developer Guide>.

=item *

An Amazon SQS policy can have a maximum of 7 actions.

=item *

To remove the ability to change queue permissions, you must deny
permission to the C<AddPermission>, C<RemovePermission>, and
C<SetQueueAttributes> actions in your IAM policy.

=back

Some actions take lists of parameters. These lists are specified using
the C<param.n> notation. Values of C<n> are integers starting from 1.
For example, a parameter list with two elements looks like this:

C<&AttributeName.1=first>

C<&AttributeName.2=second>

Cross-account permissions don't apply to this action. For more
information, see Grant cross-account permissions to a role and a user
name
(https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name)
in the I<Amazon SQS Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 2083 bytes of input
#Wed Apr 27 03:13:43 2022 rlauer
# Will try to render <a name='...'>
# Will try to render <a href='...'>


=over 5

=item Input

AddPermissionRequest

=item Output

None

=item Errors

  OverLimit

=item Method

POST

=item Request URI

/

=back



=head2 ChangeMessageVisibility

=pod

Changes the visibility timeout of a specified message in a queue to a
new value. The default visibility timeout for a message is 30 seconds.
The minimum is 0 seconds. The maximum is 12 hours. For more
information, see Visibility Timeout
(https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html)
in the I<Amazon SQS Developer Guide>.

For example, you have a message with a visibility timeout of 5 minutes.
After 3 minutes, you call C<ChangeMessageVisibility> with a timeout of
10 minutes. You can continue to call C<ChangeMessageVisibility> to
extend the visibility timeout to the maximum allowed time. If you try
to extend the visibility timeout beyond the maximum, your request is
rejected.

An Amazon SQS message has three basic states:

=over

=item 1.

Sent to a queue by a producer.

=item 2.

Received from the queue by a consumer.

=item 3.

Deleted from the queue.

=back

A message is considered to be I<stored> after it is sent to a queue by
a producer, but not yet received from the queue by a consumer (that is,
between states 1 and 2). There is no limit to the number of stored
messages. A message is considered to be I<in flight> after it is
received from a queue by a consumer, but not yet deleted from the queue
(that is, between states 2 and 3). There is a limit to the number of
inflight messages.

Limits that apply to inflight messages are unrelated to the
I<unlimited> number of stored messages.

For most standard queues (depending on queue traffic and message
backlog), there can be a maximum of approximately 120,000 inflight
messages (received from a queue by a consumer, but not yet deleted from
the queue). If you reach this limit, Amazon SQS returns the
C<OverLimit> error message. To avoid reaching the limit, you should
delete messages from the queue after they're processed. You can also
increase the number of queues you use to process your messages. To
request a limit increase, file a support request
(https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&limitType=service-code-sqs).

For FIFO queues, there can be a maximum of 20,000 inflight messages
(received from a queue by a consumer, but not yet deleted from the
queue). If you reach this limit, Amazon SQS returns no error messages.

If you attempt to set the C<VisibilityTimeout> to a value greater than
the maximum time left, Amazon SQS returns an error. Amazon SQS doesn't
automatically recalculate and increase the timeout to the maximum
remaining time.

Unlike with a queue, when you change the visibility timeout for a
specific message the timeout value is applied immediately but isn't
saved in memory for that message. If you don't delete a message after
it is received, the visibility timeout for the message reverts to the
original timeout value (not to the value you set using the
C<ChangeMessageVisibility> action) the next time the message is
received.

=cut

#Pod::HTML2Pod conversion notes:
# 3134 bytes of input
#Wed Apr 27 03:13:43 2022 rlauer
# Will try to render <a name='...'>
# Will try to render <a href='...'>


=over 5

=item Input

ChangeMessageVisibilityRequest

=item Output

None

=item Errors

  MessageNotInflight
  ReceiptHandleIsInvalid

=item Method

POST

=item Request URI

/

=back



=head2 ChangeMessageVisibilityBatch

=pod

Changes the visibility timeout of multiple messages. This is a batch
version of C< ChangeMessageVisibility.> The result of the action on
each message is reported individually in the response. You can send up
to 10 C< ChangeMessageVisibility > requests with each
C<ChangeMessageVisibilityBatch> action.

Because the batch request can result in a combination of successful and
unsuccessful actions, you should check for batch errors even when the
call returns an HTTP status code of C<200>.

Some actions take lists of parameters. These lists are specified using
the C<param.n> notation. Values of C<n> are integers starting from 1.
For example, a parameter list with two elements looks like this:

C<&AttributeName.1=first>

C<&AttributeName.2=second>

=cut

#Pod::HTML2Pod conversion notes:
# 912 bytes of input
#Wed Apr 27 03:13:43 2022 rlauer
# Will try to render <a name='...'>
# Will try to render <a href='...'>


=over 5

=item Input

ChangeMessageVisibilityBatchRequest

=item Output

ChangeMessageVisibilityBatchResult

=item Errors

  TooManyEntriesInBatchRequest
  EmptyBatchRequest
  BatchEntryIdsNotDistinct
  InvalidBatchEntryId

=item Method

POST

=item Request URI

/

=back



=head2 CreateQueue

=pod

Creates a new standard or FIFO queue. You can pass one or more
attributes in the request. Keep the following in mind:

=over

=item *

If you don't specify the C<FifoQueue> attribute, Amazon SQS creates a
standard queue.

You can't change the queue type after you create it and you can't
convert an existing standard queue into a FIFO queue. You must either
create a new FIFO queue for your application or delete your existing
standard queue and recreate it as a FIFO queue. For more information,
see Moving From a Standard Queue to a FIFO Queue
(https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-moving)
in the I<Amazon SQS Developer Guide>.

=item *

If you don't provide a value for an attribute, the queue is created
with the default value for the attribute.

=item *

If you delete a queue, you must wait at least 60 seconds before
creating a queue with the same name.

=back

To successfully create a new queue, you must provide a queue name that
adheres to the limits related to queues
(https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/limits-queues.html)
and is unique within the scope of your queues.

After you create a queue, you must wait at least one second after the
queue is created to be able to use the queue.

To get the queue URL, use the C< GetQueueUrl > action. C< GetQueueUrl >
requires only the C<QueueName> parameter. be aware of existing queue
names:

=over

=item *

If you provide the name of an existing queue along with the exact names
and values of all the queue's attributes, C<CreateQueue> returns the
queue URL for the existing queue.

=item *

If the queue name, attribute names, or attribute values don't match an
existing queue, C<CreateQueue> returns an error.

=back

Some actions take lists of parameters. These lists are specified using
the C<param.n> notation. Values of C<n> are integers starting from 1.
For example, a parameter list with two elements looks like this:

C<&AttributeName.1=first>

C<&AttributeName.2=second>

Cross-account permissions don't apply to this action. For more
information, see Grant cross-account permissions to a role and a user
name
(https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name)
in the I<Amazon SQS Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 2701 bytes of input
#Wed Apr 27 03:13:43 2022 rlauer
# Will try to render <a name='...'>
# Will try to render <a href='...'>


=over 5

=item Input

CreateQueueRequest

=item Output

CreateQueueResult

=item Errors

  QueueDeletedRecently
  QueueNameExists

=item Method

POST

=item Request URI

/

=back



=head2 DeleteMessage

=pod

Deletes the specified message from the specified queue. To select the
message to delete, use the C<ReceiptHandle> of the message (I<not> the
C<MessageId> which you receive when you send the message). Amazon SQS
can delete a message from a queue even if a visibility timeout setting
causes the message to be locked by another consumer. Amazon SQS
automatically deletes messages left in a queue longer than the
retention period configured for the queue.

The C<ReceiptHandle> is associated with a I<specific instance> of
receiving a message. If you receive a message more than once, the
C<ReceiptHandle> is different each time you receive a message. When you
use the C<DeleteMessage> action, you must provide the most recently
received C<ReceiptHandle> for the message (otherwise, the request
succeeds, but the message might not be deleted).

For standard queues, it is possible to receive a message even after you
delete it. This might happen on rare occasions if one of the servers
which stores a copy of the message is unavailable when you send the
request to delete the message. The copy remains on the server and might
be returned to you during a subsequent receive request. You should
ensure that your application is idempotent, so that receiving a message
more than once does not cause issues.

=cut

#Pod::HTML2Pod conversion notes:
# 1401 bytes of input
#Wed Apr 27 03:13:43 2022 rlauer
# Will try to render <a name='...'>
# Will try to render <a href='...'>


=over 5

=item Input

DeleteMessageRequest

=item Output

None

=item Errors

  InvalidIdFormat
  ReceiptHandleIsInvalid

=item Method

POST

=item Request URI

/

=back



=head2 DeleteMessageBatch

=pod

Deletes up to ten messages from the specified queue. This is a batch
version of C< DeleteMessage.> The result of the action on each message
is reported individually in the response.

Because the batch request can result in a combination of successful and
unsuccessful actions, you should check for batch errors even when the
call returns an HTTP status code of C<200>.

Some actions take lists of parameters. These lists are specified using
the C<param.n> notation. Values of C<n> are integers starting from 1.
For example, a parameter list with two elements looks like this:

C<&AttributeName.1=first>

C<&AttributeName.2=second>

=cut

#Pod::HTML2Pod conversion notes:
# 765 bytes of input
#Wed Apr 27 03:13:43 2022 rlauer
# Will try to render <a name='...'>
# Will try to render <a href='...'>


=over 5

=item Input

DeleteMessageBatchRequest

=item Output

DeleteMessageBatchResult

=item Errors

  TooManyEntriesInBatchRequest
  EmptyBatchRequest
  BatchEntryIdsNotDistinct
  InvalidBatchEntryId

=item Method

POST

=item Request URI

/

=back



=head2 DeleteQueue

=pod

Deletes the queue specified by the C<QueueUrl>, regardless of the
queue's contents.

Be careful with the C<DeleteQueue> action: When you delete a queue, any
messages in the queue are no longer available.

When you delete a queue, the deletion process takes up to 60 seconds.
Requests you send involving that queue during the 60 seconds might
succeed. For example, a C< SendMessage > request might succeed, but
after 60 seconds the queue and the message you sent no longer exist.

When you delete a queue, you must wait at least 60 seconds before
creating a queue with the same name.

Cross-account permissions don't apply to this action. For more
information, see Grant cross-account permissions to a role and a user
name
(https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name)
in the I<Amazon SQS Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 1057 bytes of input
#Wed Apr 27 03:13:43 2022 rlauer
# Will try to render <a name='...'>
# Will try to render <a href='...'>


=over 5

=item Input

DeleteQueueRequest

=item Output

None

=item Errors

  

=item Method

POST

=item Request URI

/

=back



=head2 GetQueueAttributes

=pod

Gets attributes for the specified queue.

To determine whether a queue is FIFO
(https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html),
you can check whether C<QueueName> ends with the C<.fifo> suffix.

=cut

#Pod::HTML2Pod conversion notes:
# 299 bytes of input
#Wed Apr 27 03:13:43 2022 rlauer
# Will try to render <a name='...'>
# Will try to render <a href='...'>


=over 5

=item Input

GetQueueAttributesRequest

=item Output

GetQueueAttributesResult

=item Errors

  InvalidAttributeName

=item Method

POST

=item Request URI

/

=back



=head2 GetQueueUrl

=pod

Returns the URL of an existing Amazon SQS queue.

To access a queue that belongs to another AWS account, use the
C<QueueOwnerAWSAccountId> parameter to specify the account ID of the
queue's owner. The queue's owner must grant you permission to access
the queue. For more information about shared queue access, see C<
AddPermission > or see Allow Developers to Write Messages to a Shared
Queue
(https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-writing-an-sqs-policy.html#write-messages-to-shared-queue)
in the I<Amazon SQS Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 626 bytes of input
#Wed Apr 27 03:13:43 2022 rlauer
# Will try to render <a name='...'>
# Will try to render <a href='...'>


=over 5

=item Input

GetQueueUrlRequest

=item Output

GetQueueUrlResult

=item Errors

  QueueDoesNotExist

=item Method

POST

=item Request URI

/

=back



=head2 ListDeadLetterSourceQueues

=pod

Returns a list of your queues that have the C<RedrivePolicy> queue
attribute configured with a dead-letter queue.

The C<ListDeadLetterSourceQueues> methods supports pagination. Set
parameter C<MaxResults> in the request to specify the maximum number of
results to be returned in the response. If you do not set
C<MaxResults>, the response includes a maximum of 1,000 results. If you
set C<MaxResults> and there are additional results to display, the
response includes a value for C<NextToken>. Use C<NextToken> as a
parameter in your next request to C<ListDeadLetterSourceQueues> to
receive the next page of results.

For more information about using dead-letter queues, see Using Amazon
SQS Dead-Letter Queues
(https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html)
in the I<Amazon SQS Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 971 bytes of input
#Wed Apr 27 03:13:43 2022 rlauer
# Will try to render <a name='...'>
# Will try to render <a href='...'>


=over 5

=item Input

ListDeadLetterSourceQueuesRequest

=item Output

ListDeadLetterSourceQueuesResult

=item Errors

  QueueDoesNotExist

=item Method

POST

=item Request URI

/

=back



=head2 ListQueueTags

=pod

List all cost allocation tags added to the specified Amazon SQS queue.
For an overview, see Tagging Your Amazon SQS Queues
(https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-tags.html)
in the I<Amazon SQS Developer Guide>.

Cross-account permissions don't apply to this action. For more
information, see Grant cross-account permissions to a role and a user
name
(https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name)
in the I<Amazon SQS Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 667 bytes of input
#Wed Apr 27 03:13:43 2022 rlauer
# Will try to render <a name='...'>
# Will try to render <a href='...'>


=over 5

=item Input

ListQueueTagsRequest

=item Output

ListQueueTagsResult

=item Errors

  

=item Method

POST

=item Request URI

/

=back



=head2 ListQueues

=pod

Returns a list of your queues in the current region. The response
includes a maximum of 1,000 results. If you specify a value for the
optional C<QueueNamePrefix> parameter, only queues with a name that
begins with the specified value are returned.

The C<listQueues> methods supports pagination. Set parameter
C<MaxResults> in the request to specify the maximum number of results
to be returned in the response. If you do not set C<MaxResults>, the
response includes a maximum of 1,000 results. If you set C<MaxResults>
and there are additional results to display, the response includes a
value for C<NextToken>. Use C<NextToken> as a parameter in your next
request to C<listQueues> to receive the next page of results.

Cross-account permissions don't apply to this action. For more
information, see Grant cross-account permissions to a role and a user
name
(https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name)
in the I<Amazon SQS Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 1201 bytes of input
#Wed Apr 27 03:13:43 2022 rlauer
# Will try to render <a name='...'>
# Will try to render <a href='...'>


=over 5

=item Input

ListQueuesRequest

=item Output

ListQueuesResult

=item Errors

  

=item Method

POST

=item Request URI

/

=back



=head2 PurgeQueue

=pod

Deletes the messages in a queue specified by the C<QueueURL> parameter.

When you use the C<PurgeQueue> action, you can't retrieve any messages
deleted from a queue.

The message deletion process takes up to 60 seconds. We recommend
waiting for 60 seconds regardless of your queue's size.

Messages sent to the queue I<before> you call C<PurgeQueue> might be
received but are deleted within the next minute.

Messages sent to the queue I<after> you call C<PurgeQueue> might be
deleted while the queue is being purged.

=cut

#Pod::HTML2Pod conversion notes:
# 622 bytes of input
#Wed Apr 27 03:13:43 2022 rlauer
# Will try to render <a name='...'>
# Will try to render <a href='...'>


=over 5

=item Input

PurgeQueueRequest

=item Output

None

=item Errors

  QueueDoesNotExist
  PurgeQueueInProgress

=item Method

POST

=item Request URI

/

=back



=head2 ReceiveMessage

=pod

Retrieves one or more messages (up to 10), from the specified queue.
Using the C<WaitTimeSeconds> parameter enables long-poll support. For
more information, see Amazon SQS Long Polling
(https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-long-polling.html)
in the I<Amazon SQS Developer Guide>.

Short poll is the default behavior where a weighted random set of
machines is sampled on a C<ReceiveMessage> call. Thus, only the
messages on the sampled machines are returned. If the number of
messages in the queue is small (fewer than 1,000), you most likely get
fewer messages than you requested per C<ReceiveMessage> call. If the
number of messages in the queue is extremely small, you might not
receive any messages in a particular C<ReceiveMessage> response. If
this happens, repeat the request.

For each message returned, the response includes the following:

=over

=item *

The message body.

=item *

An MD5 digest of the message body. For information about MD5, see
RFC1321 (https://www.ietf.org/rfc/rfc1321.txt).

=item *

The C<MessageId> you received when you sent the message to the queue.

=item *

The receipt handle.

=item *

The message attributes.

=item *

An MD5 digest of the message attributes.

=back

The receipt handle is the identifier you must provide when deleting the
message. For more information, see Queue and Message Identifiers
(https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-message-identifiers.html)
in the I<Amazon SQS Developer Guide>.

You can provide the C<VisibilityTimeout> parameter in your request. The
parameter is applied to the messages that Amazon SQS returns in the
response. If you don't include the parameter, the overall visibility
timeout for the queue is used for the returned messages. For more
information, see Visibility Timeout
(https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html)
in the I<Amazon SQS Developer Guide>.

A message that isn't deleted or a message whose visibility isn't
extended before the visibility timeout expires counts as a failed
receive. Depending on the configuration of the queue, the message might
be sent to the dead-letter queue.

In the future, new attributes might be added. If you write code that
calls this action, we recommend that you structure your code so that it
can handle new attributes gracefully.

=cut

#Pod::HTML2Pod conversion notes:
# 2636 bytes of input
#Wed Apr 27 03:13:43 2022 rlauer
# Will try to render <a name='...'>
# Will try to render <a href='...'>


=over 5

=item Input

ReceiveMessageRequest

=item Output

ReceiveMessageResult

=item Errors

  OverLimit

=item Method

POST

=item Request URI

/

=back



=head2 RemovePermission

=pod

Revokes any permissions in the queue policy that matches the specified
C<Label> parameter.

=over

=item *

Only the owner of a queue can remove permissions from it.

=item *

Cross-account permissions don't apply to this action. For more
information, see Grant cross-account permissions to a role and a user
name
(https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name)
in the I<Amazon SQS Developer Guide>.

=item *

To remove the ability to change queue permissions, you must deny
permission to the C<AddPermission>, C<RemovePermission>, and
C<SetQueueAttributes> actions in your IAM policy.

=back

=cut

#Pod::HTML2Pod conversion notes:
# 816 bytes of input
#Wed Apr 27 03:13:42 2022 rlauer
# Will try to render <a name='...'>
# Will try to render <a href='...'>


=over 5

=item Input

RemovePermissionRequest

=item Output

None

=item Errors

  

=item Method

POST

=item Request URI

/

=back



=head2 SendMessage

=pod

Delivers a message to the specified queue.

A message can include only XML, JSON, and unformatted text. The
following Unicode characters are allowed:

C<#x9> | C<#xA> | C<#xD> | C<#x20> to C<#xD7FF> | C<#xE000> to
C<#xFFFD> | C<#x10000> to C<#x10FFFF>

Any characters not included in this list will be rejected. For more
information, see the W3C specification for characters
(http://www.w3.org/TR/REC-xml/#charsets).

=cut

#Pod::HTML2Pod conversion notes:
# 570 bytes of input
#Wed Apr 27 03:13:42 2022 rlauer
# Will try to render <a name='...'>
# Will try to render <a href='...'>


=over 5

=item Input

SendMessageRequest

=item Output

SendMessageResult

=item Errors

  InvalidMessageContents
  UnsupportedOperation

=item Method

POST

=item Request URI

/

=back



=head2 SendMessageBatch

=pod

Delivers up to ten messages to the specified queue. This is a batch
version of C< SendMessage.> For a FIFO queue, multiple messages within
a single batch are enqueued in the order they are sent.

The result of sending each message is reported individually in the
response. Because the batch request can result in a combination of
successful and unsuccessful actions, you should check for batch errors
even when the call returns an HTTP status code of C<200>.

The maximum allowed individual message size and the maximum total
payload size (the sum of the individual lengths of all of the batched
messages) are both 256 KB (262,144 bytes).

A message can include only XML, JSON, and unformatted text. The
following Unicode characters are allowed:

C<#x9> | C<#xA> | C<#xD> | C<#x20> to C<#xD7FF> | C<#xE000> to
C<#xFFFD> | C<#x10000> to C<#x10FFFF>

Any characters not included in this list will be rejected. For more
information, see the W3C specification for characters
(http://www.w3.org/TR/REC-xml/#charsets).

If you don't specify the C<DelaySeconds> parameter for an entry, Amazon
SQS uses the default value for the queue.

Some actions take lists of parameters. These lists are specified using
the C<param.n> notation. Values of C<n> are integers starting from 1.
For example, a parameter list with two elements looks like this:

C<&AttributeName.1=first>

C<&AttributeName.2=second>

=cut

#Pod::HTML2Pod conversion notes:
# 1668 bytes of input
#Wed Apr 27 03:13:43 2022 rlauer
# Will try to render <a name='...'>
# Will try to render <a href='...'>


=over 5

=item Input

SendMessageBatchRequest

=item Output

SendMessageBatchResult

=item Errors

  TooManyEntriesInBatchRequest
  EmptyBatchRequest
  BatchEntryIdsNotDistinct
  BatchRequestTooLong
  InvalidBatchEntryId
  UnsupportedOperation

=item Method

POST

=item Request URI

/

=back



=head2 SetQueueAttributes

=pod

Sets the value of one or more queue attributes. When you change a
queue's attributes, the change can take up to 60 seconds for most of
the attributes to propagate throughout the Amazon SQS system. Changes
made to the C<MessageRetentionPeriod> attribute can take up to 15
minutes.

=over

=item *

In the future, new attributes might be added. If you write code that
calls this action, we recommend that you structure your code so that it
can handle new attributes gracefully.

=item *

Cross-account permissions don't apply to this action. For more
information, see Grant cross-account permissions to a role and a user
name
(https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name)
in the I<Amazon SQS Developer Guide>.

=item *

To remove the ability to change queue permissions, you must deny
permission to the C<AddPermission>, C<RemovePermission>, and
C<SetQueueAttributes> actions in your IAM policy.

=back

=cut

#Pod::HTML2Pod conversion notes:
# 1126 bytes of input
#Wed Apr 27 03:13:43 2022 rlauer
# Will try to render <a name='...'>
# Will try to render <a href='...'>


=over 5

=item Input

SetQueueAttributesRequest

=item Output

None

=item Errors

  InvalidAttributeName

=item Method

POST

=item Request URI

/

=back



=head2 TagQueue

=pod

Add cost allocation tags to the specified Amazon SQS queue. For an
overview, see Tagging Your Amazon SQS Queues
(https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-tags.html)
in the I<Amazon SQS Developer Guide>.

When you use queue tags, keep the following guidelines in mind:

=over

=item *

Adding more than 50 tags to a queue isn't recommended.

=item *

Tags don't have any semantic meaning. Amazon SQS interprets tags as
character strings.

=item *

Tags are case-sensitive.

=item *

A new tag with a key identical to that of an existing tag overwrites
the existing tag.

=back

For a full list of tag restrictions, see Quotas related to queues
(https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-limits.html#limits-queues)
in the I<Amazon SQS Developer Guide>.

Cross-account permissions don't apply to this action. For more
information, see Grant cross-account permissions to a role and a user
name
(https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name)
in the I<Amazon SQS Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 1298 bytes of input
#Wed Apr 27 03:13:42 2022 rlauer
# Will try to render <a name='...'>
# Will try to render <a href='...'>


=over 5

=item Input

TagQueueRequest

=item Output

None

=item Errors

  

=item Method

POST

=item Request URI

/

=back



=head2 UntagQueue

=pod

Remove cost allocation tags from the specified Amazon SQS queue. For an
overview, see Tagging Your Amazon SQS Queues
(https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-tags.html)
in the I<Amazon SQS Developer Guide>.

Cross-account permissions don't apply to this action. For more
information, see Grant cross-account permissions to a role and a user
name
(https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name)
in the I<Amazon SQS Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 661 bytes of input
#Wed Apr 27 03:13:43 2022 rlauer
# Will try to render <a name='...'>
# Will try to render <a href='...'>


=over 5

=item Input

UntagQueueRequest

=item Output

None

=item Errors

  

=item Method

POST

=item Request URI

/

=back



=head1 NOTE

Autogenerated by Amazon/API/Botocore.pm at Wed Apr 27 03:13:42 2022

=head1 LICENSE AND COPYRIGHT

This module is free software it may be used, redistributed and/or
modified under the same terms as Perl itself.

=cut  
