
package CloudSearchDomain;

# Autogenerated by lib/Amazon/API/Botocore.pm 1.2.7 at Tue Apr 12 13:46:33 2022

use strict;
use warnings;

use parent qw{ Amazon::API };

our @API_METHODS = qw{
  Search
  Suggest
  UploadDocuments
};

our $VERSION = '1.2.7';

sub new {
  my ( $class, @options ) = @_;
  $class = ref($class) || $class;

  my %options = ref $options[0] ? %{ $options[0] } : @options;

  my $self = $class->SUPER::new(
    { service           => 'cloudsearch',
      endpoint_prefix   => 'cloudsearchdomain',
      version           => '2013-01-01',
      target_prefix     => '',
      api_methods       => \@API_METHODS,
      content_type      => 'application/json',
      botocore_metadata => {
        'protocol'         => 'rest-json',
        'serviceFullName'  => 'Amazon CloudSearch Domain',
        'uid'              => 'cloudsearchdomain-2013-01-01',
        'signatureVersion' => 'v4',
        'apiVersion'       => '2013-01-01',
        'serviceId'        => 'CloudSearch Domain',
        'signingName'      => 'cloudsearch',
        'endpointPrefix'   => 'cloudsearchdomain',
        'jsonVersion'      => '1.1'
      },
      botocore_operations => {
        'Suggest' => {
          'errors' => [ { 'shape' => 'SearchException' } ],
          'input'  => { 'shape' => 'SuggestRequest' },
          'http'   => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' =>
                '/2013-01-01/suggest?format=sdk&pretty=true'
            },
            'requestUri' => '/2013-01-01/suggest?format=sdk&pretty=true',
            'method'     => 'GET'
          },
          'name'   => 'Suggest',
          'output' => { 'shape' => 'SuggestResponse' }
        },
        'Search' => {
          'errors' => [ { 'shape' => 'SearchException' } ],
          'input'  => { 'shape' => 'SearchRequest' },
          'http'   => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/2013-01-01/search?format=sdk&pretty=true'
            },
            'requestUri' => '/2013-01-01/search?format=sdk&pretty=true',
            'method'     => 'GET'
          },
          'name'   => 'Search',
          'output' => { 'shape' => 'SearchResponse' }
        },
        'UploadDocuments' => {
          'errors' => [ { 'shape' => 'DocumentServiceException' } ],
          'input'  => { 'shape' => 'UploadDocumentsRequest' },
          'http'   => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/2013-01-01/documents/batch?format=sdk'
            },
            'requestUri' => '/2013-01-01/documents/batch?format=sdk',
            'method'     => 'POST'
          },
          'name'   => 'UploadDocuments',
          'output' => { 'shape' => 'UploadDocumentsResponse' }
        }
      },
      debug => $ENV{DEBUG} // 0,
      %options
    }
  );

  return $self;
} ## end sub new

1;

__END__

=pod

=head1 NAME

CloudSearchDomain

=head1 DESCRIPTION

Amazon CloudSearch Domain

=head1 VERSION

Version 1.2.7

=head1 METHODS


=head2 Search

=pod

Retrieves a list of documents that match the specified search criteria.
How you specify the search criteria depends on which query parser you
use. Amazon CloudSearch supports four query parsers:

=over

=item * C<simple>: search all C<text> and C<text-array> fields for the
specified string. Search for phrases, individual terms, and prefixes.

=item * C<structured>: search specific fields, construct compound
queries using Boolean operators, and use advanced features such as term
boosting and proximity searching.

=item * C<lucene>: specify search criteria using the Apache Lucene
query parser syntax.

=item * C<dismax>: specify search criteria using the simplified subset
of the Apache Lucene query parser syntax defined by the DisMax query
parser.

=back

For more information, see Searching Your Data in the I<Amazon
CloudSearch Developer Guide>.

The endpoint for submitting C<Search> requests is domain-specific. You
submit search requests to a domain's search endpoint. To get the search
endpoint for your domain, use the Amazon CloudSearch configuration
service C<DescribeDomains> action. A domain's endpoints are also
displayed on the domain dashboard in the Amazon CloudSearch console.

=cut

#Pod::HTML2Pod conversion notes:
# 1391 bytes of input
#Tue Apr 12 13:46:33 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

SearchRequest

=item Output

SearchResponse

=item Errors

  SearchException

=item Method

GET

=item Request URI

/2013-01-01/search?format=sdk&pretty=true

=back



=head2 Suggest

=pod

Retrieves autocomplete suggestions for a partial query string. You can
use suggestions enable you to display likely matches before users
finish typing. In Amazon CloudSearch, suggestions are based on the
contents of a particular text field. When you request suggestions,
Amazon CloudSearch finds all of the documents whose values in the
suggester field start with the specified query string. The beginning of
the field must match the query string to be considered a match.

For more information about configuring suggesters and retrieving
suggestions, see Getting Suggestions in the I<Amazon CloudSearch
Developer Guide>.

The endpoint for submitting C<Suggest> requests is domain-specific. You
submit suggest requests to a domain's search endpoint. To get the
search endpoint for your domain, use the Amazon CloudSearch
configuration service C<DescribeDomains> action. A domain's endpoints
are also displayed on the domain dashboard in the Amazon CloudSearch
console.

=cut

#Pod::HTML2Pod conversion notes:
# 1114 bytes of input
#Tue Apr 12 13:46:33 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

SuggestRequest

=item Output

SuggestResponse

=item Errors

  SearchException

=item Method

GET

=item Request URI

/2013-01-01/suggest?format=sdk&pretty=true

=back



=head2 UploadDocuments

=pod

Posts a batch of documents to a search domain for indexing. A document
batch is a collection of add and delete operations that represent the
documents you want to add, update, or delete from your domain. Batches
can be described in either JSON or XML. Each item that you want Amazon
CloudSearch to return as a search result (such as a product) is
represented as a document. Every document has a unique ID and one or
more fields that contain the data that you want to search and return in
results. Individual documents cannot contain more than 1 MB of data.
The entire batch cannot exceed 5 MB. To get the best possible upload
performance, group add and delete operations in batches that are close
the 5 MB limit. Submitting a large volume of single-document batches
can overload a domain's document service.

The endpoint for submitting C<UploadDocuments> requests is
domain-specific. To get the document endpoint for your domain, use the
Amazon CloudSearch configuration service C<DescribeDomains> action. A
domain's endpoints are also displayed on the domain dashboard in the
Amazon CloudSearch console.

For more information about formatting your data for Amazon CloudSearch,
see Preparing Your Data in the I<Amazon CloudSearch Developer Guide>.
For more information about uploading data for indexing, see Uploading
Data in the I<Amazon CloudSearch Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 1609 bytes of input
#Tue Apr 12 13:46:33 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

UploadDocumentsRequest

=item Output

UploadDocumentsResponse

=item Errors

  DocumentServiceException

=item Method

POST

=item Request URI

/2013-01-01/documents/batch?format=sdk

=back



=head1 NOTE

Autogenerated by lib/Amazon/API/Botocore.pm at Tue Apr 12 13:46:33 2022

=head1 LICENSE AND COPYRIGHT

This module is free software it may be used, redistributed and/or
modified under the same terms as Perl itself.

=cut  
