use strict;
use warnings;
use Perl::Lint::Policy::ValuesAndExpressions::ProhibitComplexVersion;
use t::Policy::Util qw/fetch_violations/;
use Test::Base::Less;

my $class_name = 'ValuesAndExpressions::ProhibitComplexVersion';

filters {
    params => [qw/eval/], # TODO wrong!
};

for my $block (blocks) {
    my $violations = fetch_violations($class_name, $block->input, $block->params);
    is scalar @$violations, $block->failures, $block->dscr;
}

done_testing;

__DATA__

===
--- dscr: basic passes
--- failures: 0
--- params:
--- input
our $VERSION = 2.718;
our $VERSION = '3.14159';
our $VERSION = q{3.14159};
our $VERSION = "1.718";
our $VERSION = qq{1.718};
use version; our $VERSION = qv('1.2.3');
($VERSION) = q$REVISION: 42$ =~ m/(\d+)/;
$VERSION = "\$Foo::VERSION";
$VERSION = $main::VERSION;

===
--- dscr: basic failures
--- failures: 5
--- params:
--- input
use Foo; our $VERSION = $Foo::VERSION;
use Foo; our $VERSION = $FOO_VERSION;
our $VERSION = $Foo::VERSION;
our $VERSION = "$Foo::VERSION";
our $VERSION = qq{$Foo::VERSION};

===
--- dscr: configure 'use version' to fail.
--- failures: 1
--- params: {prohibit_complex_version => {forbid_use_version => '1'}}
--- input
use version; our $VERSION = qv('1.2.3');

===
--- dscr: passes from the ProhibitMagicNumbers.run treasury.
--- failures: 0
--- params:
--- input
(our $VERSION = q$Revision$) =~ s/Revision //;
(our $VERSION) = '$Revision$' =~ /([\d.]+)/;
(our $VERSION) = sprintf "%d", q$Revision$ =~ /Revision:\s+(\S+)/;
our $VERSION : unique = "1.23";
our $VERSION : unique = '1.23';
our $VERSION = "$local_variable v1.23";
our $VERSION = "1." . sprintf "%d", q$Revision$ =~ /: (\d+)/;
our $VERSION = "1.2.3";
our $VERSION = "1.2.3.0";
our $VERSION = "1.2.3.blah";
our $VERSION = "1.23 (liblgrp version $local_variable)";
our $VERSION = "1.23 2005-05-20";
our $VERSION = "1.23";
our $VERSION = "1.23, 2004-12-07";
our $VERSION = "1.23_blah";
our $VERSION = "1.23blah";
our $VERSION = "1.2_3";
our $VERSION = "123";
our $VERSION = "INSERT";
our $VERSION = $VERSION = (qw($Revision$))[1];
our $VERSION = $local_variable;
our $VERSION = '$Date$'; $VERSION =~ s|^\$Date:\s*([0-9]{4})/([0-9]{2})/([0-9]{2})\s.*|\1.\2.\3| ;
our $VERSION = '$Revision$' =~ /\$Revision:\s+([^\s]+)/;
our $VERSION = '$Revision$';
our $VERSION = '-123 blah';
our $VERSION = '1.' . qw $Revision$[1];
our $VERSION = '1.' . sprintf "%d", (qw($Revision$))[1];
our $VERSION = '1.' . sprintf("%d", (qw($Revision$))[1]);
our $VERSION = '1.2.3';
our $VERSION = '1.2.3.0';
our $VERSION = '1.2.3blah';
our $VERSION = '1.23';
our $VERSION = '1.23_blah';
our $VERSION = '1.23blah';
our $VERSION = '1.2_3';
our $VERSION = '1.23' || do { q $Revision$ =~ /(\d+)/; sprintf "%4.2f", $1 / 100 };
our $VERSION = '123';
our $VERSION = ('$Revision$' =~ /(\d+.\d+)/)[ 0];
our $VERSION = ('$Revision$' =~ /(\d+\.\d+)/);
our $VERSION = ('$Revision$' =~ m/(\d+)/)[0];
our $VERSION = (q$Revision$ =~ /([\d\.]+)/);
our $VERSION = (q$Revision$ =~ /(\d+)/g)[0];
our $VERSION = (qq$Revision$ =~ /(\d+)/)[0];
our $VERSION = (qw$Revision$)[-1];
our $VERSION = (qw$Revision$)[1];
our $VERSION = (qw($Revision$))[1];
our $VERSION = (split(/ /, '$Revision$'))[1];
our $VERSION = (split(/ /, '$Revision$'))[2];
our $VERSION = 1.2.3;
our $VERSION = 1.23;
our $VERSION = 1.2_3;
our $VERSION = 123;
our $VERSION = [ qw{ $Revision$ } ]->[1];
our $VERSION = do { (my $v = q%version: 1.23 %) =~ s/.*://; sprintf("%d.%d", split(/\./, $v), 0) };
our $VERSION = do { (my $v = q%version: 123 %) =~ s/.*://; sprintf("%d.%d", split(/\./, $v), 0) };
our $VERSION = do { q $Revision$ =~ /(\d+)/; sprintf "%4.2f", $1 / 100 };
our $VERSION = do { q$Revision$ =~ /Revision: (\d+)/; sprintf "1.%d", $1; };
our $VERSION = do {(q$URL$=~ m$.*/(?:tags|branches)/([^/ \t]+)$)[0] || "0.0"};
our $VERSION = q$0.04$;
our $VERSION = q$Revision$;
our $VERSION = q(0.14);
our $VERSION = qv('1.2.3');
our $VERSION = qw(1.2.3);
our $VERSION = sprintf "%.02f", $local_variable/100 + 0.3;
our $VERSION = sprintf "%.3f", 123 + substr(q$Revision$, 4)/1000;
our $VERSION = sprintf "%d.%d", '$Revision$' =~ /(\d+)\.(\d+)/;
our $VERSION = sprintf "%d.%d", '$Revision$' =~ /(\d+)/g;
our $VERSION = sprintf "%d.%d", '$Revision$' =~ /(\d+)\.(\d+)/;
our $VERSION = sprintf "%d.%d", q$Revision$ =~ /: (\d+)\.(\d+)/;
our $VERSION = sprintf "%d.%d", q$Revision$ =~ /(\d+)/g;
our $VERSION = sprintf "%d.%d", q$Revision$ =~ /(\d+)\.(\d+)/;
our $VERSION = sprintf "%d.%d", q$Revision$ =~ /(\d+)\.(\d+)/g;
our $VERSION = sprintf "%d.%d", q$Revision$ =~ /: (\d+)\.(\d+)/;
our $VERSION = sprintf "%d.%d", q$Revision$ =~ m/ (\d+) \. (\d+) /xg;
our $VERSION = sprintf "%d.%d", q$Revision$ ~~ m:P5:g/(\d+)/;
our $VERSION = sprintf "%d.%d%d", (split /\D+/, '$Name: beta0_1_1 $')[1..3];
# This deserves to fail, if I can make it do it.
our $VERSION = sprintf "%s.%s%s", q$Name: Rel-0_90 $ =~ /^Name: Rel-(\d+)_(\d+)(_\d+|)\s*$/, 999, "00", join "", (gmtime)[5] +1900, map {sprintf "%d", $_} (gmtime)[4]+1;
our $VERSION = sprintf "1.%d", '$Revision$' =~ /(\d+)/;
our $VERSION = sprintf "1.%d", q$Revision$ =~ /(\d+)/g;
our $VERSION = sprintf '%d.%d', (q$Revision$ =~ /(\d+)\.(\d+)/);
our $VERSION = sprintf '%d.%d', q$Revision$ =~ /(\d+)\.(\d+)/;
our $VERSION = sprintf '%d.%d', q$Revision$ =~ /(\d+)\.(\d+)/;
our $VERSION = sprintf '%s', 'q$Revision$' =~ /\S+\s+(\S+)\s+/ ;
our $VERSION = sprintf '%s', 'q$Revision$' =~ /\S+\s+(\S+)\s+/ ;
our $VERSION = sprintf '%s', q$Revision$ =~ /Revision:\s+(\S+)\s+/ ;
our $VERSION = sprintf '%s', q{$Revision$} =~ /\S+\s+(\S+)/ ;
our $VERSION = sprintf '1.%d', (q$Revision$ =~ /\D(\d+)\s*$/)[0] + 15;
our $VERSION = sprintf("%d", q$Id: SomeModule.pm,v 1.23 2006/04/10 22:39:38 matthew Exp $ =~ /\s(\d+)\s/);
our $VERSION = sprintf("%d", q$Id: SomeModule.pm,v 1.23 2006/04/10 22:39:39 matthew Exp $ =~ /\s(\d+)\s/);
our $VERSION = sprintf("%d.%d", "Revision: 2006.0626" =~ /(\d+)\.(\d+)/);
our $VERSION = sprintf("%d.%d", '$Name: v0_018-2006-06-15b $' =~ /(\d+)_(\d+)/, 0, 0);
our $VERSION = sprintf("%d.%d", 0, q$Revision$ =~ /(\d+)\.(\d+)/);
our $VERSION = sprintf("%d.%d", q$Name: REL-0-13 $ =~ /(\d+)-(\d+)/, 999, 99);
our $VERSION = sprintf("%d.%d", q$Name: ical-parser-html-1-6 $ =~ /(\d+)-(\d+)/);
our $VERSION = sprintf("%d.%d", q$Revision$ =~ /(\d+)\.(\d+)/);
our $VERSION = sprintf("%d.%d", q$Revision$ =~ /(\d+)\.(\d+)/o);
our $VERSION = sprintf("%d.%d", q$Revision$ =~ m/(\d+)\.(\d+)/);
our $VERSION = sprintf("%d.%d", q$Revision$=~/(\d+)\.(\d+)/);
our $VERSION = sprintf("%d.%d", q'$Revision$' =~ /(\d+)\.(\d+)/);
our $VERSION = sprintf("%d.%d.%d", 0, q$Revision$ =~ /(\d+)\.(\d+)/);
our $VERSION = sprintf("1.%d", q$Revision$ =~ / (\d+) /);
our $VERSION = sprintf("1.%d", q$Revision$ =~ /(\d+)/);
our $VERSION = sprintf("1.2%d%d", q$Revision$ =~ /(\d+)\.(\d+)/);
our $VERSION = sprintf('%d.%d', '$Revision$' =~ /(\d+)\.(\d+)/);
our $VERSION = sprintf('%d.%d', q$Revision$ =~ /(\d+)\.(\d+)/);
our $VERSION = sprintf('%d.%d', q$Revision$ =~ /(\d+)\.(\d+)/);
our $VERSION = substr q$Revision$, 10;
our $VERSION = substr(q$Revision$, 10);
our $VERSION = v1.2.3.0;
our $VERSION = v1.2.3;
our $VERSION = v1.23;
our $VERSION = version->new('1.2.3');
our $VERSION = version->new(qw$Revision$);
our ($PACKAGE, $VERSION) = ('') x 2;
our ($VERSION) = "1.23";
our ($VERSION) = '$Revision$' =~ /\$Revision:\s+([^\s]+)/;
our ($VERSION) = '$Revision$' =~ /\$Revision:\s+([^\s]+)/;
our ($VERSION) = '$Revision$' =~ m{ \$Revision: \s+ (\S+) }x;
our ($VERSION) = '$Revision$' =~ m{ \$Revision: \s+ (\S+) }xm;
our ($VERSION) = '$Revision$'=~/(\d+(\.\d+))/;
our ($VERSION) = '$Revision$' =~ m{ \$Revision: \s+ (\S+) }x;
our ($VERSION) = '1.23' =~ /([.,\d]+)/;
our ($VERSION) = '1.23';
our ($VERSION) = ($local_variable =~ /(\d+\.\d+)/);
our ($VERSION) = ('$Revision$' =~ /(\d+\.\d+)/) ;
our ($VERSION) = ('$Revision$' =~ /(\d+\.\d+)/);
our ($VERSION) = ('$Revision$' =~ m/([\.\d]+)/) ;
our ($VERSION) = (q$Revision$ =~ /([\d\.]+)/);
our ($VERSION) = (qq$Revision$ =~ /(\d+)/)[0];
our ($VERSION) = 1.23;
# These deserve to fail if I can make them do it.
our ($VERSION) = q$Revision$ =~ /Revision:\s+(\S+)/ or $VERSION = "1.23";
our ($VERSION) = q$Revision$ =~ /Revision:\s+(\S+)/ or $VERSION = '1.23';
our ($VERSION) = q$Revision$ =~ /[\d.]+/g;
our ($VERSION) = q$Revision$ =~ /^Revision:\s+(\S+)/ or $VERSION = "1.23";
use version; our $VERSION = 1.23;
use version; our $VERSION = qv("1.2.3");
use version; our $VERSION = qv('1.2.3');
use version; our $VERSION = qv('1.23');
use version; our $VERSION = qv((qw$Revision$)[1] / 1000);
use version; our $VERSION = version->new('1.23');

===
--- dscr: failures from the ProhibitMagicNumbers.run treasury.
--- failures: 11
--- params:
--- input
our $VERSION = $SomeOtherModule::VERSION;
our $VERSION = ((require SomeOtherModule), $SomeOtherModule::VERSION)[1];
our $VERSION = SomeOtherModule::RCSVersion('$Revision$');
our $VERSION = SomeOtherModule::VERSION;
our $VERSION = do { require mod_perl2; $mod_perl2::VERSION };
our $VERSION = eval { require version; version::qv((qw$Revision$)[1] / 1000) };
our ($VERSION) = $SomeOtherModule::VERSION;
# This deserves to fail, if I can make it do it.
# our $VERSION = sprintf "%s.%s%s", q$Name: Rel-0_90 $ =~ /^Name: Rel-(\d+)_(\d+)(_\d+|)\s*$/, 999, "00", join "", (gmtime)[5] +1900, map {sprintf "%d", $_} (gmtime)[4]+1;
# These deserve to fail if I can make them do it.
# our ($VERSION) = q$Revision$ =~ /Revision:\s+(\S+)/ or $VERSION = "1.23";
# our ($VERSION) = q$Revision$ =~ /Revision:\s+(\S+)/ or $VERSION = '1.23';
# our ($VERSION) = q$Revision$ =~ /[\d.]+/g;
# our ($VERSION) = q$Revision$ =~ /^Revision:\s+(\S+)/ or $VERSION = "1.23";
require SomeOtherModule; our $VERSION = $SomeOtherModule::VERSION;
use SomeOtherModule; our $VERSION = $SomeOtherModule::VERSION;
use SomeOtherModule; our $VERSION = SomeOtherModule::VERSION;
use base 'SomeOtherModule'; our $VERSION = $SomeOtherModule::VERSION;

===
--- dscr: no lint
--- failures: 4
--- params:
--- input
our $VERSION = $SomeOtherModule::VERSION;
our $VERSION = ((require SomeOtherModule), $SomeOtherModule::VERSION)[1];
our $VERSION = SomeOtherModule::RCSVersion('$Revision$'); ## no lint
our $VERSION = SomeOtherModule::VERSION;
our $VERSION = do { require mod_perl2; $mod_perl2::VERSION };
