use strict;

BEGIN {
  die "The Win32::Setupsup module works only on Windows NT\nOS unsupported\n"
      unless eval { Win32::IsWinNT() };

  if ($] < 5.006) {
    print STDERR <<"";
  This Makefile.PL requires Perl 5.6 or better.
  Use Win32::Setupsup 1.01 with older versions of Perl:
    http://www.cpan.org/modules/by-module/Win32/setupsup.1.0.1.0.zip

    exit 1;
  } # end if version too small
}

use warnings;

use Config qw(%Config);
use ExtUtils::MakeMaker 6.30;

#---------------------------------------------------------------------

my %args = (
  NAME           => 'Win32::Setupsup',
  DEFINE         => '-DPERL_5_6_0 -D_CRT_SECURE_NO_WARNINGS',
  OBJECT => 'list.obj misc.obj plmisc.obj setupsup.obj wstring.obj resource.res',
  VERSION_FROM   => 'Setupsup.pm', # finds $VERSION
  'BUILD_REQUIRES' => {
    'Test::More' => '0',
    'Win32::TieRegistry' => '0'
  },
  'CONFIGURE_REQUIRES' => {
    'ExtUtils::MakeMaker' => '6.30'
  },
  'PREREQ_PM' => {
    'Carp' => '0',
    'Exporter' => '0',
    'Win32API::Registry' => '0',
    'XSLoader' => '0'
  },
  'ABSTRACT' => 'Remote control for Windows applications',
  'AUTHOR' => 'Jens Helberg <jens.helberg@de.bosch.com>, Christopher J. Madsen <perl@cjmweb.net>',
  'LICENSE' => 'gpl',
);

if ($Config{cc} =~ /gcc/i) {
  # This is old C++ code:
  $args{CCFLAGS} = '-fpermissive -Wno-conversion-null -Wno-write-strings';
  $args{OBJECT} =~ s/ resource\.res/ resource.opc/;

  no warnings 'once';
  *MY::postamble = sub {
         return <<'MAKE_FRAG';
.rc.opc:
	windres $*.rc $*.opc

MAKE_FRAG
  } # end MY::postamble
} # end if using GCC (Strawberry Perl)

unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $args{BUILD_REQUIRES};
  my $pp = $args{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $args{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

delete $args{LICENSE}
  unless eval { ExtUtils::MakeMaker->VERSION(6.31) };

my $mm = WriteMakefile(%args);

#---------------------------------------------------------------------
print "Exporting version number to afxres.h\n";

my $version = $mm->{VERSION};
$version =~ /^(\d+)\.(\d+)(\d)/ or die "Can't understand version '$version'";
my $versionnum = "$1,$2,$3,0";

open(VER, '>afxres.h') or die "Can't create afxres.h: $!";
print VER <<"";
// This file was automatically generated by Makefile.PL\n
#define VS_VERSION_INFO     1\n
#include <winresrc.h>\n
#define SETUPSUP_VERSION    "$version"
#define SETUPSUP_VERSION_NUM $versionnum

close VER;
