/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty9.server.session;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import org.seleniumhq.jetty9.io.CyclicTimeout;
import org.seleniumhq.jetty9.server.session.SessionData;
import org.seleniumhq.jetty9.server.session.SessionHandler;
import org.seleniumhq.jetty9.util.log.Log;
import org.seleniumhq.jetty9.util.log.Logger;
import org.seleniumhq.jetty9.util.thread.Locker;

public class Session
implements SessionHandler.SessionIf {
    private static final Logger LOG = Log.getLogger("org.seleniumhq.jetty9.server.session");
    public static final String SESSION_CREATED_SECURE = "org.seleniumhq.jetty9.security.sessionCreatedSecure";
    protected final SessionData _sessionData;
    protected final SessionHandler _handler;
    protected String _extendedId;
    protected long _requests;
    protected boolean _idChanged;
    protected boolean _newSession;
    protected State _state = State.VALID;
    protected Locker _lock = new Locker();
    protected boolean _resident = false;
    protected final SessionInactivityTimer _sessionInactivityTimer;

    public Session(SessionHandler handler, HttpServletRequest request, SessionData data) {
        this._handler = handler;
        this._sessionData = data;
        this._newSession = true;
        this._sessionData.setDirty(true);
        this._requests = 1L;
        this._sessionInactivityTimer = new SessionInactivityTimer();
    }

    public Session(SessionHandler handler, SessionData data) {
        this._handler = handler;
        this._sessionData = data;
        this._sessionInactivityTimer = new SessionInactivityTimer();
    }

    public long getRequests() {
        try (Locker.Lock lock = this._lock.lock();){
            long l = this._requests;
            return l;
        }
    }

    public void setExtendedId(String extendedId) {
        this._extendedId = extendedId;
    }

    protected void cookieSet() {
        try (Locker.Lock lock = this._lock.lock();){
            this._sessionData.setCookieSet(this._sessionData.getAccessed());
        }
    }

    protected boolean access(long time) {
        try (Locker.Lock lock = this._lock.lock();){
            if (!this.isValid()) {
                boolean bl = false;
                return bl;
            }
            this._newSession = false;
            long lastAccessed = this._sessionData.getAccessed();
            this._sessionData.setAccessed(time);
            this._sessionData.setLastAccessed(lastAccessed);
            this._sessionData.calcAndSetExpiry(time);
            if (this.isExpiredAt(time)) {
                this.invalidate();
                boolean bl = false;
                return bl;
            }
            ++this._requests;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session {} accessed, stopping timer, active requests={}", this.getId(), this._requests);
            }
            this._sessionInactivityTimer.cancel();
            boolean bl = true;
            return bl;
        }
    }

    protected void complete() {
        try (Locker.Lock lock = this._lock.lock();){
            --this._requests;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session {} complete, active requests={}", this.getId(), this._requests);
            }
            if (this._requests == 0L) {
                this._sessionInactivityTimer.schedule();
            }
        }
    }

    protected boolean isExpiredAt(long time) {
        try (Locker.Lock lock = this._lock.lock();){
            boolean bl = this._sessionData.isExpiredAt(time);
            return bl;
        }
    }

    protected boolean isIdleLongerThan(int sec) {
        long now = System.currentTimeMillis();
        try (Locker.Lock lock = this._lock.lock();){
            boolean bl = this._sessionData.getAccessed() + (long)(sec * 1000) <= now;
            return bl;
        }
    }

    protected void callSessionAttributeListeners(String name, Object newValue, Object oldValue) {
        if (newValue == null || !newValue.equals(oldValue)) {
            if (oldValue != null) {
                this.unbindValue(name, oldValue);
            }
            if (newValue != null) {
                this.bindValue(name, newValue);
            }
            if (this._handler == null) {
                throw new IllegalStateException("No session manager for session " + this._sessionData.getId());
            }
            this._handler.doSessionAttributeListeners(this, name, oldValue, newValue);
        }
    }

    public void unbindValue(String name, Object value) {
        if (value != null && value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent(this, name));
        }
    }

    public void bindValue(String name, Object value) {
        if (value != null && value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent(this, name));
        }
    }

    public void didActivate() {
        HttpSessionEvent event = new HttpSessionEvent(this);
        Iterator<String> iter = this._sessionData.getKeys().iterator();
        while (iter.hasNext()) {
            Object value = this._sessionData.getAttribute(iter.next());
            if (!(value instanceof HttpSessionActivationListener)) continue;
            HttpSessionActivationListener listener = (HttpSessionActivationListener)value;
            listener.sessionDidActivate(event);
        }
    }

    public void willPassivate() {
        HttpSessionEvent event = new HttpSessionEvent(this);
        Iterator<String> iter = this._sessionData.getKeys().iterator();
        while (iter.hasNext()) {
            Object value = this._sessionData.getAttribute(iter.next());
            if (!(value instanceof HttpSessionActivationListener)) continue;
            HttpSessionActivationListener listener = (HttpSessionActivationListener)value;
            listener.sessionWillPassivate(event);
        }
    }

    public boolean isValid() {
        try (Locker.Lock lock = this._lock.lock();){
            boolean bl = this._state == State.VALID;
            return bl;
        }
    }

    public long getCookieSetTime() {
        try (Locker.Lock lock = this._lock.lock();){
            long l = this._sessionData.getCookieSet();
            return l;
        }
    }

    @Override
    public long getCreationTime() throws IllegalStateException {
        try (Locker.Lock lock = this._lock.lock();){
            this.checkValidForRead();
            long l = this._sessionData.getCreated();
            return l;
        }
    }

    @Override
    public String getId() {
        try (Locker.Lock lock = this._lock.lock();){
            String string = this._sessionData.getId();
            return string;
        }
    }

    public String getExtendedId() {
        return this._extendedId;
    }

    public String getContextPath() {
        return this._sessionData.getContextPath();
    }

    public String getVHost() {
        return this._sessionData.getVhost();
    }

    @Override
    public long getLastAccessedTime() {
        try (Locker.Lock lock = this._lock.lock();){
            long l = this._sessionData.getLastAccessed();
            return l;
        }
    }

    @Override
    public ServletContext getServletContext() {
        if (this._handler == null) {
            throw new IllegalStateException("No session manager for session " + this._sessionData.getId());
        }
        return this._handler._context;
    }

    @Override
    public void setMaxInactiveInterval(int secs) {
        try (Locker.Lock lock = this._lock.lock();){
            this._sessionData.setMaxInactiveMs((long)secs * 1000L);
            this._sessionData.calcAndSetExpiry();
            this._sessionData.setDirty(true);
            this.updateInactivityTimer();
            if (LOG.isDebugEnabled()) {
                if (secs <= 0) {
                    LOG.debug("Session {} is now immortal (maxInactiveInterval={})", this._sessionData.getId(), secs);
                } else {
                    LOG.debug("Session {} maxInactiveInterval={}", this._sessionData.getId(), secs);
                }
            }
        }
    }

    public void updateInactivityTimer() {
        try (Locker.Lock lock = this._lock.lock();){
            long maxInactive = this._sessionData.getMaxInactiveMs();
            int evictionPolicy = this.getSessionHandler().getSessionCache().getEvictionPolicy();
            if (maxInactive <= 0L) {
                if (evictionPolicy < 1) {
                    this._sessionInactivityTimer.setTimeout(-1L);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Session {} is immortal && no inactivity eviction", this.getId());
                    }
                } else {
                    this._sessionInactivityTimer.setTimeout(TimeUnit.SECONDS.toMillis(evictionPolicy));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Session {} is immortal; evict after {} sec inactivity", this.getId(), evictionPolicy);
                    }
                }
            } else if (evictionPolicy == -1) {
                this._sessionInactivityTimer.setTimeout(this._sessionData.getMaxInactiveMs());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Session {} no eviction", this.getId());
                }
            } else if (evictionPolicy == 0) {
                this._sessionInactivityTimer.setTimeout(-1L);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Session {} evict on exit", this.getId());
                }
            } else {
                this._sessionInactivityTimer.setTimeout(Math.min(maxInactive, TimeUnit.SECONDS.toMillis(evictionPolicy)));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Session {} timer set to lesser of maxInactive={} and inactivityEvict={}", this.getId(), maxInactive, evictionPolicy);
                }
            }
        }
    }

    @Override
    public int getMaxInactiveInterval() {
        try (Locker.Lock lock = this._lock.lock();){
            long maxInactiveMs = this._sessionData.getMaxInactiveMs();
            int n = (int)(maxInactiveMs < 0L ? -1L : maxInactiveMs / 1000L);
            return n;
        }
    }

    @Override
    @Deprecated
    public HttpSessionContext getSessionContext() {
        this.checkValidForRead();
        return SessionHandler.__nullSessionContext;
    }

    public SessionHandler getSessionHandler() {
        return this._handler;
    }

    protected void checkValidForWrite() throws IllegalStateException {
        this.checkLocked();
        if (this._state == State.INVALID) {
            throw new IllegalStateException("Not valid for write: id=" + this._sessionData.getId() + " created=" + this._sessionData.getCreated() + " accessed=" + this._sessionData.getAccessed() + " lastaccessed=" + this._sessionData.getLastAccessed() + " maxInactiveMs=" + this._sessionData.getMaxInactiveMs() + " expiry=" + this._sessionData.getExpiry());
        }
        if (this._state == State.INVALIDATING) {
            return;
        }
        if (!this.isResident()) {
            throw new IllegalStateException("Not valid for write: id=" + this._sessionData.getId() + " not resident");
        }
    }

    protected void checkValidForRead() throws IllegalStateException {
        this.checkLocked();
        if (this._state == State.INVALID) {
            throw new IllegalStateException("Invalid for read: id=" + this._sessionData.getId() + " created=" + this._sessionData.getCreated() + " accessed=" + this._sessionData.getAccessed() + " lastaccessed=" + this._sessionData.getLastAccessed() + " maxInactiveMs=" + this._sessionData.getMaxInactiveMs() + " expiry=" + this._sessionData.getExpiry());
        }
        if (this._state == State.INVALIDATING) {
            return;
        }
        if (!this.isResident()) {
            throw new IllegalStateException("Invalid for read: id=" + this._sessionData.getId() + " not resident");
        }
    }

    protected void checkLocked() throws IllegalStateException {
        if (!this._lock.isLocked()) {
            throw new IllegalStateException("Session not locked");
        }
    }

    @Override
    public Object getAttribute(String name) {
        try (Locker.Lock lock = this._lock.lock();){
            this.checkValidForRead();
            Object object = this._sessionData.getAttribute(name);
            return object;
        }
    }

    @Override
    @Deprecated
    public Object getValue(String name) {
        try (Locker.Lock lock = this._lock.lock();){
            Object object = this._sessionData.getAttribute(name);
            return object;
        }
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        try (Locker.Lock lock = this._lock.lock();){
            this.checkValidForRead();
            final Iterator<String> itor = this._sessionData.getKeys().iterator();
            Enumeration<String> enumeration = new Enumeration<String>(){

                @Override
                public boolean hasMoreElements() {
                    return itor.hasNext();
                }

                @Override
                public String nextElement() {
                    return (String)itor.next();
                }
            };
            return enumeration;
        }
    }

    public int getAttributes() {
        return this._sessionData.getKeys().size();
    }

    public Set<String> getNames() {
        return Collections.unmodifiableSet(this._sessionData.getKeys());
    }

    @Override
    @Deprecated
    public String[] getValueNames() throws IllegalStateException {
        try (Locker.Lock lock = this._lock.lock();){
            this.checkValidForRead();
            Iterator<String> itor = this._sessionData.getKeys().iterator();
            if (!itor.hasNext()) {
                String[] stringArray = new String[]{};
                return stringArray;
            }
            ArrayList<String> names = new ArrayList<String>();
            while (itor.hasNext()) {
                names.add(itor.next());
            }
            String[] stringArray = names.toArray(new String[names.size()]);
            return stringArray;
        }
    }

    @Override
    public void setAttribute(String name, Object value) {
        Object old = null;
        try (Locker.Lock lock = this._lock.lock();){
            this.checkValidForWrite();
            old = this._sessionData.setAttribute(name, value);
        }
        if (value == null && old == null) {
            return;
        }
        this.callSessionAttributeListeners(name, value, old);
    }

    @Override
    @Deprecated
    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        this.setAttribute(name, null);
    }

    @Override
    @Deprecated
    public void removeValue(String name) {
        this.setAttribute(name, null);
    }

    public void renewId(HttpServletRequest request) {
        if (this._handler == null) {
            throw new IllegalStateException("No session manager for session " + this._sessionData.getId());
        }
        String id = null;
        String extendedId = null;
        try (Locker.Lock lock = this._lock.lock();){
            this.checkValidForWrite();
            id = this._sessionData.getId();
            extendedId = this.getExtendedId();
        }
        String newId = this._handler._sessionIdManager.renewSessionId(id, extendedId, request);
        try (Locker.Lock lock = this._lock.lock();){
            this.checkValidForWrite();
            this._sessionData.setId(newId);
            this.setExtendedId(this._handler._sessionIdManager.getExtendedId(newId, request));
        }
        this.setIdChanged(true);
    }

    @Override
    public void invalidate() {
        if (this._handler == null) {
            throw new IllegalStateException("No session manager for session " + this._sessionData.getId());
        }
        boolean result = this.beginInvalidate();
        try {
            if (result) {
                this._handler.getSessionIdManager().invalidateAll(this._sessionData.getId());
            }
        }
        catch (Exception e) {
            LOG.warn(e);
        }
    }

    public Locker.Lock lock() {
        return this._lock.lock();
    }

    public Locker.Lock lockIfNotHeld() {
        return this._lock.lock();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean beginInvalidate() {
        boolean result = false;
        try (Locker.Lock lock = this._lock.lock();){
            switch (this._state) {
                case INVALID: {
                    throw new IllegalStateException();
                }
                case VALID: {
                    result = true;
                    this._state = State.INVALIDATING;
                    return result;
                }
                default: {
                    if (!LOG.isDebugEnabled()) return result;
                    LOG.debug("Session {} already being invalidated", this._sessionData.getId());
                    return result;
                }
            }
        }
    }

    @Deprecated
    protected void doInvalidate() throws IllegalStateException {
        this.finishInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishInvalidate() throws IllegalStateException {
        try (Locker.Lock lock = this._lock.lock();){
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("invalidate {}", this._sessionData.getId());
                }
                if (this._state == State.VALID || this._state == State.INVALIDATING) {
                    Set<String> keys = null;
                    keys = this._sessionData.getKeys();
                    for (String key : keys) {
                        Object old = this._sessionData.setAttribute(key, null);
                        if (old == null) {
                            return;
                        }
                        this.callSessionAttributeListeners(key, null, old);
                    }
                }
            }
            finally {
                this._state = State.INVALID;
            }
        }
    }

    @Override
    public boolean isNew() throws IllegalStateException {
        try (Locker.Lock lock = this._lock.lock();){
            this.checkValidForRead();
            boolean bl = this._newSession;
            return bl;
        }
    }

    public void setIdChanged(boolean changed) {
        try (Locker.Lock lock = this._lock.lock();){
            this._idChanged = changed;
        }
    }

    public boolean isIdChanged() {
        try (Locker.Lock lock = this._lock.lock();){
            boolean bl = this._idChanged;
            return bl;
        }
    }

    @Override
    public Session getSession() {
        return this;
    }

    protected SessionData getSessionData() {
        return this._sessionData;
    }

    public void setResident(boolean resident) {
        this._resident = resident;
        if (this._resident) {
            this.updateInactivityTimer();
        } else {
            this._sessionInactivityTimer.destroy();
        }
    }

    public boolean isResident() {
        return this._resident;
    }

    public class SessionInactivityTimer {
        protected final CyclicTimeout _timer;
        protected long _msec = -1L;

        public SessionInactivityTimer() {
            this._timer = new CyclicTimeout(Session.this.getSessionHandler().getScheduler()){

                @Override
                public void onTimeoutExpired() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Timer expired for session {}", Session.this.getId());
                    }
                    Session.this.getSessionHandler().sessionInactivityTimerExpired(Session.this);
                }
            };
        }

        public void setTimeout(long ms) {
            this._msec = ms;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session {} timer={}ms", Session.this.getId(), ms);
            }
        }

        public void schedule() {
            if (this._msec > 0L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("(Re)starting timer for session {} at {}ms", Session.this.getId(), this._msec);
                }
                this._timer.schedule(this._msec, TimeUnit.MILLISECONDS);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Not starting timer for session {}", Session.this.getId());
            }
        }

        public void cancel() {
            this._timer.cancel();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cancelled timer for session {}", Session.this.getId());
            }
        }

        public void destroy() {
            this._timer.destroy();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Destroyed timer for session {}", Session.this.getId());
            }
        }
    }

    public static enum State {
        VALID,
        INVALID,
        INVALIDATING;

    }
}

