/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.rest.RestishHandler;

public class GetAllSessions
implements RestishHandler<List<SessionInfo>> {
    private final Response response = new Response();
    private volatile DriverSessions allSessions;

    public GetAllSessions(DriverSessions allSession) {
        this.allSessions = allSession;
    }

    @Override
    public List<SessionInfo> handle() throws Exception {
        Set<SessionId> sessions = this.allSessions.getSessions();
        List sessionInfo = sessions.stream().map(id -> new SessionInfo((SessionId)id, this.allSessions.get((SessionId)id).getCapabilities())).collect(Collectors.toList());
        return ImmutableList.copyOf(sessionInfo);
    }

    public Response getResponse() {
        return this.response;
    }

    public static class SessionInfo {
        private final SessionId id;
        private final Map<String, ?> capabilities;

        private SessionInfo(SessionId id, Map<String, ?> capabilities) {
            this.id = id;
            this.capabilities = capabilities;
        }

        public String getId() {
            return this.id.toString();
        }

        public Map<String, ?> getCapabilities() {
            return this.capabilities;
        }
    }
}

