/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.grid.web.Route;
import org.openqa.selenium.grid.web.Routes;
import org.openqa.selenium.injector.Injector;
import org.openqa.selenium.injector.UnableToInstaniateInstanceException;
import org.openqa.selenium.remote.http.HttpRequest;

public class CombinedRoute
extends Route<CombinedRoute> {
    private final List<Routes> factories;

    CombinedRoute(List<Routes> factories) {
        this.factories = ImmutableList.copyOf(factories);
    }

    @Override
    protected void validate() {
    }

    @Override
    protected CommandHandler newHandler(Injector injector, HttpRequest request) {
        for (Routes factory : this.factories) {
            try {
                Optional<CommandHandler> handler = factory.match(injector, request);
                if (!handler.isPresent()) continue;
                return handler.get();
            }
            catch (IllegalArgumentException | UnableToInstaniateInstanceException runtimeException) {
            }
        }
        return this.getFallback(injector);
    }
}

