/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.jcip.annotations.ThreadSafe;
import org.openqa.grid.common.exception.CapabilityNotPresentOnTheGridException;
import org.openqa.grid.common.exception.GridException;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.TestSession;
import org.openqa.selenium.remote.DesiredCapabilities;

@ThreadSafe
public class ProxySet
implements Iterable<RemoteProxy> {
    private final Set<RemoteProxy> proxies = new CopyOnWriteArraySet<RemoteProxy>();
    private static final Logger log = Logger.getLogger(ProxySet.class.getName());
    private volatile boolean throwOnCapabilityNotPresent = true;
    private Comparator<RemoteProxy> proxyComparator = (o1, o2) -> {
        double p2used;
        double p1used = o1.getResourceUsageInPercent();
        if (p1used == (p2used = (double)o2.getResourceUsageInPercent())) {
            long time2lastUsed;
            long time1lastUsed = o1.getLastSessionStart();
            if (time1lastUsed == (time2lastUsed = o2.getLastSessionStart())) {
                return 0;
            }
            return time1lastUsed < time2lastUsed ? -1 : 1;
        }
        return p1used < p2used ? -1 : 1;
    };

    public ProxySet(boolean throwOnCapabilityNotPresent) {
        this.throwOnCapabilityNotPresent = throwOnCapabilityNotPresent;
    }

    public void teardown() {
        this.proxies.forEach(RemoteProxy::teardown);
    }

    public boolean hasCapability(Map<String, Object> requestedCapability) {
        return this.proxies.stream().anyMatch(remoteProxy -> remoteProxy.hasCapability(requestedCapability));
    }

    public RemoteProxy remove(RemoteProxy proxy) {
        for (RemoteProxy p : this.proxies) {
            if (!p.equals(proxy)) continue;
            this.proxies.remove(p);
            return p;
        }
        throw new IllegalStateException("Did not contain proxy" + proxy);
    }

    public void add(RemoteProxy proxy) {
        this.proxies.add(proxy);
    }

    public boolean contains(RemoteProxy o) {
        return this.proxies.contains(o);
    }

    public List<RemoteProxy> getBusyProxies() {
        return this.proxies.stream().filter(RemoteProxy::isBusy).collect(Collectors.toList());
    }

    public RemoteProxy getProxyById(String id) {
        return this.proxies.stream().filter(proxy -> proxy.getId().equals(id)).findFirst().orElse(null);
    }

    public boolean isEmpty() {
        return this.proxies.isEmpty();
    }

    public List<RemoteProxy> getSorted() {
        ArrayList<RemoteProxy> sorted = new ArrayList<RemoteProxy>(this.proxies);
        Collections.sort(sorted, this.proxyComparator);
        return sorted;
    }

    public TestSession getNewSession(Map<String, Object> desiredCapabilities) {
        List<RemoteProxy> sorted = this.getSorted();
        log.fine("Available nodes: " + sorted);
        return sorted.stream().map(proxy -> proxy.getNewSession(desiredCapabilities)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public Iterator<RemoteProxy> iterator() {
        return this.proxies.iterator();
    }

    public int size() {
        return this.proxies.size();
    }

    public void verifyAbilityToHandleDesiredCapabilities(Map<String, Object> desiredCapabilities) {
        if (this.proxies.isEmpty()) {
            if (this.throwOnCapabilityNotPresent) {
                throw new GridException("Empty pool of VM for setup " + new DesiredCapabilities(desiredCapabilities));
            }
            log.warning("Empty pool of nodes.");
        }
        if (!this.hasCapability(desiredCapabilities)) {
            if (this.throwOnCapabilityNotPresent) {
                throw new CapabilityNotPresentOnTheGridException(desiredCapabilities);
            }
            log.warning("grid doesn't contain " + new DesiredCapabilities(desiredCapabilities) + " at the moment.");
        }
    }

    public void setThrowOnCapabilityNotPresent(boolean throwOnCapabilityNotPresent) {
        this.throwOnCapabilityNotPresent = throwOnCapabilityNotPresent;
    }

    public boolean isThrowOnCapabilityNotPresent() {
        return this.throwOnCapabilityNotPresent;
    }
}

